/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;
import owl.logic.propositional.sat.Solver;

public class EmersonLeiAcceptance {
    @Nullable
    private PropositionalFormula<Integer> expression;
    @Nonnegative
    private final int sets;

    EmersonLeiAcceptance(int sets) {
        Preconditions.checkArgument((sets >= 0 ? 1 : 0) != 0);
        this.sets = sets;
    }

    private EmersonLeiAcceptance(int sets, PropositionalFormula<Integer> expression) {
        this(sets);
        this.expression = Objects.requireNonNull(expression);
    }

    public static EmersonLeiAcceptance of(PropositionalFormula<Integer> expression) {
        PropositionalFormula<Integer> normalisedExpression = expression.nnf();
        if (Solver.model(normalisedExpression).isEmpty()) {
            return new EmersonLeiAcceptance(0, PropositionalFormula.falseConstant());
        }
        if (Solver.model(PropositionalFormula.Negation.of(normalisedExpression)).isEmpty()) {
            return AllAcceptance.ofPartial(PropositionalFormula.trueConstant()).orElseThrow();
        }
        Optional<BuchiAcceptance> buchiAcceptance = BuchiAcceptance.ofPartial(normalisedExpression);
        if (buchiAcceptance.isPresent()) {
            return buchiAcceptance.get();
        }
        Optional<CoBuchiAcceptance> coBuchiAcceptance = CoBuchiAcceptance.ofPartial(normalisedExpression);
        if (coBuchiAcceptance.isPresent()) {
            return coBuchiAcceptance.get();
        }
        Optional<? extends GeneralizedBuchiAcceptance> generalizedBuchiAcceptance = GeneralizedBuchiAcceptance.ofPartial(normalisedExpression);
        if (generalizedBuchiAcceptance.isPresent()) {
            return generalizedBuchiAcceptance.get();
        }
        Optional<? extends GeneralizedCoBuchiAcceptance> generalizedCoBuchiAcceptance = GeneralizedCoBuchiAcceptance.ofPartial(normalisedExpression);
        if (generalizedCoBuchiAcceptance.isPresent()) {
            return generalizedCoBuchiAcceptance.get();
        }
        Optional<RabinAcceptance> rabinAcceptance = RabinAcceptance.ofPartial(normalisedExpression);
        if (rabinAcceptance.isPresent()) {
            return rabinAcceptance.get();
        }
        Optional<? extends GeneralizedRabinAcceptance> generalizedRabinAcceptance = GeneralizedRabinAcceptance.ofPartial(normalisedExpression);
        if (generalizedRabinAcceptance.isPresent()) {
            return generalizedRabinAcceptance.get();
        }
        return new EmersonLeiAcceptance(EmersonLeiAcceptance.acceptanceSets(normalisedExpression), normalisedExpression);
    }

    public final int acceptanceSets() {
        return this.sets;
    }

    private static int acceptanceSets(PropositionalFormula<Integer> expression) {
        Set<Integer> variables = expression.variables();
        int max = -1;
        for (int variable : variables) {
            if (variable < 0) {
                throw new IllegalArgumentException();
            }
            max = Math.max(max, variable);
        }
        return max + 1;
    }

    public final PropositionalFormula<Integer> booleanExpression() {
        if (this.expression == null) {
            this.expression = Objects.requireNonNull(this.lazyBooleanExpression());
            assert (this.acceptanceSets() >= EmersonLeiAcceptance.acceptanceSets(this.expression));
        }
        return this.expression;
    }

    @Nullable
    protected PropositionalFormula<Integer> lazyBooleanExpression() {
        return null;
    }

    @Nullable
    public String name() {
        return null;
    }

    public List<Object> nameExtra() {
        return List.of();
    }

    public Optional<ImmutableBitSet> acceptingSet() {
        return Solver.model(this.booleanExpression()).map(ImmutableBitSet::copyOf);
    }

    public Optional<ImmutableBitSet> rejectingSet() {
        return Solver.model(PropositionalFormula.Negation.of(this.booleanExpression())).map(ImmutableBitSet::copyOf);
    }

    public boolean isAccepting(BitSet set) {
        return this.isAccepting(BitSet2.asSet(set));
    }

    public boolean isAccepting(Set<Integer> set) {
        return this.booleanExpression().evaluate(set);
    }

    public boolean isAcceptingEdge(Edge<?> edge) {
        return this.isAccepting(edge.colours());
    }

    public <S> boolean isWellFormedAutomaton(Automaton<S, ?> automaton) {
        return automaton.states().stream().allMatch(state -> automaton.edges(state).stream().allMatch(edge -> edge.colours().last().orElse(-1) < this.acceptanceSets()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != EmersonLeiAcceptance.class) {
            return false;
        }
        EmersonLeiAcceptance that = (EmersonLeiAcceptance)o;
        return this.sets == that.sets && this.expression.equals(that.expression);
    }

    public int hashCode() {
        return 31 * this.booleanExpression().hashCode() + this.sets;
    }

    public final String toString() {
        String name = this.name();
        return (String)(name == null ? this.getClass().getSimpleName() : name + " " + this.nameExtra()) + ": " + this.acceptanceSets() + " " + this.booleanExpression();
    }
}

