/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.logic.propositional.PropositionalFormula;

public final class RabinAcceptance
extends GeneralizedRabinAcceptance {
    private RabinAcceptance(List<GeneralizedRabinAcceptance.RabinPair> pairs) {
        super(List.copyOf(pairs));
        Preconditions.checkArgument((this.acceptanceSets() == 2 * this.pairs.size() ? 1 : 0) != 0);
        for (GeneralizedRabinAcceptance.RabinPair pair : this.pairs) {
            Preconditions.checkArgument((pair.finSet() + 1 == pair.infSet() ? 1 : 0) != 0);
        }
    }

    public static RabinAcceptance of(int count) {
        ArrayList<GeneralizedRabinAcceptance.RabinPair> pairs = new ArrayList<GeneralizedRabinAcceptance.RabinPair>(count);
        for (int index = 0; index < count; ++index) {
            pairs.add(GeneralizedRabinAcceptance.RabinPair.of(index * 2));
        }
        return new RabinAcceptance(pairs);
    }

    public static RabinAcceptance of(List<GeneralizedRabinAcceptance.RabinPair> pairs) {
        return new RabinAcceptance(pairs);
    }

    public static RabinAcceptance of(GeneralizedRabinAcceptance.RabinPair ... pairs) {
        return RabinAcceptance.of(List.of(pairs));
    }

    public static Optional<RabinAcceptance> ofPartial(PropositionalFormula<Integer> formula) {
        BitSet seenSets = new BitSet();
        for (PropositionalFormula<Integer> pair : PropositionalFormula.disjuncts(formula.nnf())) {
            int fin = Integer.MIN_VALUE;
            int inf = Integer.MIN_VALUE;
            for (PropositionalFormula<Integer> element : PropositionalFormula.conjuncts(pair)) {
                if (element instanceof PropositionalFormula.Variable) {
                    if (inf != Integer.MIN_VALUE) {
                        return Optional.empty();
                    }
                    inf = (Integer)((PropositionalFormula.Variable)element).variable;
                    continue;
                }
                if (element instanceof PropositionalFormula.Negation) {
                    if (fin != Integer.MIN_VALUE) {
                        return Optional.empty();
                    }
                    fin = (Integer)((PropositionalFormula.Variable)((PropositionalFormula.Negation)element).operand).variable;
                    continue;
                }
                return Optional.empty();
            }
            if (fin < 0 || fin % 2 != 0 || fin + 1 != inf) {
                return Optional.empty();
            }
            seenSets.set(fin, inf + 1);
        }
        if (seenSets.length() != seenSets.cardinality()) {
            return Optional.empty();
        }
        return Optional.of(RabinAcceptance.of(seenSets.length() / 2));
    }

    @Override
    public String name() {
        return "Rabin";
    }

    @Override
    public List<Object> nameExtra() {
        return List.of(Integer.valueOf(this.pairs.size()));
    }

    public static final class Builder {
        private final List<GeneralizedRabinAcceptance.RabinPair> pairs = new ArrayList<GeneralizedRabinAcceptance.RabinPair>();
        private int sets = 0;

        public GeneralizedRabinAcceptance.RabinPair add() {
            GeneralizedRabinAcceptance.RabinPair pair = new GeneralizedRabinAcceptance.RabinPair(this.sets, this.sets + 1);
            this.pairs.add(pair);
            this.sets += 2;
            return pair;
        }

        public RabinAcceptance build() {
            return RabinAcceptance.of(this.pairs);
        }
    }
}

