/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.optimization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.collections.ImmutableBitSet;

public final class GeneralizedRabinAcceptanceOptimizations {
    private static final Logger logger = Logger.getLogger(GeneralizedRabinAcceptance.class.getName());

    private GeneralizedRabinAcceptanceOptimizations() {
    }

    public static <S> void removeComplementaryInfSets(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        List pairs = acceptance.pairs().stream().filter(GeneralizedRabinAcceptance.RabinPair::hasInfSet).collect(Collectors.toList());
        ArrayList<BitSet> pairComplementaryInfSets = new ArrayList<BitSet>(pairs.size());
        for (GeneralizedRabinAcceptance.RabinPair pair : pairs) {
            BitSet pairInfSets = new BitSet();
            pair.forEachInfSet(pairInfSets::set);
            pairComplementaryInfSets.add(pairInfSets);
        }
        AutomatonUtil.forEachNonTransientEdge(automaton, (state, edge) -> {
            ListIterator iterator = pairs.listIterator();
            while (iterator.hasNext()) {
                int pairIndex = iterator.nextIndex();
                GeneralizedRabinAcceptance.RabinPair pair = (GeneralizedRabinAcceptance.RabinPair)iterator.next();
                BitSet pairComplementary = (BitSet)pairComplementaryInfSets.get(pairIndex);
                assert (!pairComplementary.isEmpty());
                boolean finEdge = edge.colours().contains(pair.finSet());
                int i = pairComplementary.nextSetBit(0);
                while (i >= 0) {
                    if (finEdge == edge.colours().contains(i)) {
                        pairComplementary.clear(i);
                    }
                    i = pairComplementary.nextSetBit(i + 1);
                }
                if (!pairComplementary.isEmpty()) continue;
                iterator.remove();
                pairComplementaryInfSets.remove(pairIndex);
            }
        });
        BitSet indicesToRemove = new BitSet();
        pairComplementaryInfSets.forEach(indicesToRemove::or);
        if (indicesToRemove.isEmpty()) {
            return;
        }
        logger.log(Level.FINER, "Removing complementary indices {0}", indicesToRemove);
        AcceptanceOptimizations.removeAndRemapIndices(automaton, indicesToRemove);
        automaton.acceptance(acceptance.filter(indicesToRemove::get));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void minimizeEdgeImplications(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        int acceptanceSets = acceptance.acceptanceSets();
        BitSet defaultConsequent = new BitSet(acceptanceSets);
        defaultConsequent.set(0, acceptanceSets);
        BitSet[] impliesMap = new BitSet[acceptanceSets];
        Arrays.setAll(impliesMap, i -> BitSet2.copyOf(defaultConsequent));
        AutomatonUtil.forEachNonTransientEdge(automaton, (state, edge) -> edge.colours().forEach(index -> {
            BitSet consequences = impliesMap[index];
            int i = consequences.nextSetBit(0);
            while (i >= 0) {
                if (!edge.colours().contains(i)) {
                    consequences.clear(i);
                }
                i = consequences.nextSetBit(i + 1);
            }
        }));
        if (logger.isLoggable(Level.FINER)) {
            StringBuilder builder = new StringBuilder(30 * impliesMap.length);
            builder.append("Implication map:");
            for (int index2 = 0; index2 < acceptanceSets; ++index2) {
                builder.append("\n  ").append(index2).append(" => ");
                BitSet antecedent = impliesMap[index2];
                int i2 = antecedent.nextSetBit(0);
                while (i2 >= 0) {
                    if (index2 != i2) {
                        builder.append(i2).append(' ');
                    }
                    i2 = antecedent.nextSetBit(i2 + 1);
                }
            }
            logger.log(Level.FINER, builder.toString());
        }
        BitSet indicesToRemove = new BitSet();
        for (GeneralizedRabinAcceptance.RabinPair pair : acceptance.pairs()) {
            pair.forEachInfSet(index -> {
                if (indicesToRemove.get(index)) {
                    return;
                }
                BitSet consequences = impliesMap[index];
                int consequenceIndex = consequences.nextSetBit(0);
                while (consequenceIndex >= 0) {
                    if (consequenceIndex != index && !indicesToRemove.get(consequenceIndex) && pair.isInfinite(consequenceIndex)) {
                        indicesToRemove.set(consequenceIndex);
                    }
                    consequenceIndex = consequences.nextSetBit(consequenceIndex + 1);
                }
            });
        }
        logger.log(Level.FINEST, "Implication removal: {0}", indicesToRemove);
        AcceptanceOptimizations.removeAndRemapIndices(automaton, indicesToRemove);
        automaton.acceptance(acceptance.filter(indicesToRemove::get));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void minimizeMergePairs(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        boolean someMerge;
        List pairs = ((GeneralizedRabinAcceptance)automaton.acceptance()).pairs().stream().filter(GeneralizedRabinAcceptance.RabinPair::hasInfSet).collect(Collectors.toList());
        if (pairs.isEmpty()) {
            return;
        }
        TreeMap<GeneralizedRabinAcceptance.RabinPair, BitSet> pairActiveSccs = new TreeMap<GeneralizedRabinAcceptance.RabinPair, BitSet>();
        List<Set<S>> elements = SccDecomposition.of(automaton).sccsWithoutTransient();
        int s = elements.size();
        for (int i = 0; i < s; ++i) {
            Iterator indices = AutomatonUtil.getAcceptanceSets(automaton, elements.get(i));
            for (GeneralizedRabinAcceptance.RabinPair pair2 : pairs) {
                if (!pair2.contains((ImmutableBitSet)((Object)indices))) continue;
                pairActiveSccs.computeIfAbsent(pair2, k -> new BitSet()).set(i);
            }
        }
        ArrayList<MergeClass> mergeClasses = new ArrayList<MergeClass>(pairs.size());
        pairActiveSccs.forEach((pair, activeSccs) -> mergeClasses.add(new MergeClass((GeneralizedRabinAcceptance.RabinPair)pair, (BitSet)activeSccs)));
        block2: do {
            someMerge = false;
            for (MergeClass mergeClass2 : mergeClasses) {
                someMerge = mergeClasses.removeIf(mergeClass2::tryMerge);
                if (!someMerge) continue;
                continue block2;
            }
        } while (someMerge);
        HashMap<Integer, BitSet> remapping = new HashMap<Integer, BitSet>();
        for (MergeClass aClass : mergeClasses) {
            if (aClass.pairs.size() == 1) {
                ((GeneralizedRabinAcceptance.RabinPair)Iterables.getOnlyElement(aClass.pairs)).forEachIndex(index -> remapping.put(index, BitSet2.of(index)));
            }
            int representativeFin = aClass.representativeFin;
            BitSet representativeInf = aClass.representativeInf;
            int representativeInfCount = representativeInf.cardinality();
            for (GeneralizedRabinAcceptance.RabinPair mergedPair : aClass.pairs) {
                assert (mergedPair.hasInfSet());
                remapping.put(mergedPair.finSet(), BitSet2.of(representativeFin));
                int mergedInfiniteCount = mergedPair.infSetCount();
                assert (mergedInfiniteCount <= representativeInfCount);
                PrimitiveIterator.OfInt infIterator = representativeInf.stream().iterator();
                for (int infiniteNumber = 0; infiniteNumber < mergedInfiniteCount - 1; ++infiniteNumber) {
                    remapping.put(mergedPair.infSet(infiniteNumber), BitSet2.of(infIterator.nextInt()));
                }
                int finalIndex = mergedPair.infSet(mergedInfiniteCount - 1);
                BitSet finalSet = new BitSet();
                infIterator.forEachRemaining(finalSet::set);
                assert (!finalSet.isEmpty());
                remapping.put(finalIndex, finalSet);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            List trueMerges = mergeClasses.stream().filter(mergeClass -> mergeClass.pairs.size() > 1).collect(Collectors.toList());
            logger.log(Level.FINER, "Merge classes {0}, indices {1}", new Object[]{trueMerges, remapping});
        }
        automaton.updateEdges((state, edge) -> {
            BitSet newAcceptance = new BitSet();
            edge.colours().forEach(index -> {
                BitSet indexRemapping = (BitSet)remapping.get(index);
                if (indexRemapping == null) {
                    newAcceptance.set(index);
                } else {
                    newAcceptance.or(indexRemapping);
                }
            });
            return Edge.of(edge.successor(), newAcceptance);
        });
        BitSet indicesToRemove = new BitSet();
        remapping.values().forEach(indicesToRemove::andNot);
        AcceptanceOptimizations.removeAndRemapIndices(automaton, indicesToRemove);
        automaton.acceptance(((GeneralizedRabinAcceptance)automaton.acceptance()).filter(indicesToRemove::get));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void minimizeOverlap(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        List pairs = acceptance.pairs().stream().filter(GeneralizedRabinAcceptance.RabinPair::hasInfSet).collect(Collectors.toUnmodifiableList());
        if (pairs.isEmpty()) {
            return;
        }
        automaton.updateEdges((state, edge) -> {
            if (edge.colours().isEmpty()) {
                return edge;
            }
            int overlapIndex = -1;
            for (int index = 0; index < pairs.size(); ++index) {
                GeneralizedRabinAcceptance.RabinPair pair = (GeneralizedRabinAcceptance.RabinPair)pairs.get(index);
                if (!edge.colours().contains(pair.finSet()) || !pair.containsInfinite((Edge<?>)edge)) continue;
                overlapIndex = index;
                break;
            }
            if (overlapIndex == -1) {
                return edge;
            }
            BitSet modifiedAcceptance = BitSet2.copyOf(edge.colours());
            ((GeneralizedRabinAcceptance.RabinPair)pairs.get(overlapIndex)).forEachInfSet(modifiedAcceptance::clear);
            for (int index = overlapIndex + 1; index < pairs.size(); ++index) {
                GeneralizedRabinAcceptance.RabinPair pair = (GeneralizedRabinAcceptance.RabinPair)pairs.get(index);
                if (!edge.colours().contains(pair.finSet()) || !pair.containsInfinite((Edge<?>)edge)) continue;
                pair.forEachInfSet(modifiedAcceptance::clear);
            }
            return Edge.of(edge.successor(), modifiedAcceptance);
        });
    }

    public static <S> void minimizePairImplications(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        int sccIndex;
        StringBuilder logBuilder;
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        int acceptanceSets = acceptance.acceptanceSets();
        ArrayList<GeneralizedRabinAcceptance.RabinPair> pairs = new ArrayList<GeneralizedRabinAcceptance.RabinPair>(acceptance.pairs());
        List<Set<S>> sccs = SccDecomposition.of(automaton).sccsWithoutTransient();
        ArrayList<TreeMultimap> sccImplicationList = new ArrayList<TreeMultimap>(sccs.size());
        StringBuilder stringBuilder = logBuilder = logger.isLoggable(Level.FINEST) ? new StringBuilder(200 + sccs.size() * 50) : null;
        if (logBuilder != null) {
            logBuilder.append("Implications:");
        }
        BitSet defaultConsequent = new BitSet(acceptanceSets);
        defaultConsequent.set(0, acceptanceSets);
        BitSet[] impliesMap = new BitSet[acceptanceSets];
        for (int sccIndex2 = 0; sccIndex2 < sccs.size(); ++sccIndex2) {
            Object state2;
            Set<S> scc = sccs.get(sccIndex2);
            Arrays.setAll(impliesMap, i -> BitSet2.copyOf(defaultConsequent));
            for (Object state2 : scc) {
                for (Edge edge : automaton.edges(state2)) {
                    if (!scc.contains(edge.successor())) continue;
                    edge.colours().forEach(index -> {
                        BitSet consequent = impliesMap[index];
                        int i = consequent.nextSetBit(0);
                        while (i >= 0) {
                            if (!edge.colours().contains(i)) {
                                consequent.clear(i);
                            }
                            i = consequent.nextSetBit(i + 1);
                        }
                    });
                }
            }
            TreeMultimap sccImplications = TreeMultimap.create();
            state2 = pairs.iterator();
            while (state2.hasNext()) {
                Edge edge;
                GeneralizedRabinAcceptance.RabinPair antecedent2 = (GeneralizedRabinAcceptance.RabinPair)state2.next();
                edge = pairs.iterator();
                while (edge.hasNext()) {
                    GeneralizedRabinAcceptance.RabinPair consequent2 = (GeneralizedRabinAcceptance.RabinPair)edge.next();
                    if (antecedent2.equals(consequent2) || !impliesMap[consequent2.finSet()].get(antecedent2.finSet())) continue;
                    boolean infImplied = true;
                    if (consequent2.hasInfSet()) {
                        int consequentInfIndices = consequent2.infSetCount();
                        int antecedentInfIndices = antecedent2.infSetCount();
                        for (int consequentNumber = 0; consequentNumber < consequentInfIndices; ++consequentNumber) {
                            boolean foundImplication = false;
                            int consequentIndex = consequent2.infSet(consequentNumber);
                            for (int antecedentNumber = 0; antecedentNumber < antecedentInfIndices; ++antecedentNumber) {
                                int antecedentIndex = antecedent2.infSet(antecedentNumber);
                                if (!impliesMap[antecedentIndex].get(consequentIndex)) continue;
                                foundImplication = true;
                                break;
                            }
                            if (foundImplication) continue;
                            infImplied = false;
                            break;
                        }
                    } else {
                        boolean bl = infImplied = !antecedent2.hasInfSet();
                    }
                    if (!infImplied) continue;
                    sccImplications.put((Object)antecedent2, (Object)consequent2);
                }
            }
            sccImplicationList.add(sccImplications);
            if (logBuilder == null) continue;
            logBuilder.append("\n ").append(sccIndex2).append(" - ").append(sccs.get(sccIndex2)).append("\n  Indices:");
            int i2 = 0;
            while (i2 < acceptanceSets) {
                int index2 = i2++;
                logBuilder.append("\n   ").append(index2).append(" => ");
                impliesMap[index2].stream().forEach(otherIndex -> {
                    if (index2 != otherIndex) {
                        logBuilder.append(otherIndex).append(' ');
                    }
                });
            }
            logBuilder.append("\n  Pairs:");
            if (sccImplications.isEmpty()) {
                logBuilder.append("\n   ").append("None");
                continue;
            }
            sccImplications.asMap().forEach((pair, consequences) -> logBuilder.append("\n   ").append(pair).append(" => ").append(consequences));
        }
        HashSet toRemove = new HashSet();
        pairs.stream().filter(pair -> sccImplicationList.stream().allMatch(sccImplications -> sccImplications.get(pair).stream().anyMatch(consequent -> !toRemove.contains(consequent)))).forEach(toRemove::add);
        ArrayList pairsToRemoveInSccs = new ArrayList(sccs.size());
        for (sccIndex = 0; sccIndex < sccs.size(); ++sccIndex) {
            Multimap sccImplications = (Multimap)sccImplicationList.get(sccIndex);
            HashSet toRemoveInScc = new HashSet(sccImplications.keySet().size());
            sccImplications.forEach((antecedent, consequent) -> {
                if (!(toRemove.contains(antecedent) || toRemove.contains(consequent) || toRemoveInScc.contains(consequent))) {
                    toRemoveInScc.add(antecedent);
                }
            });
            pairsToRemoveInSccs.add(toRemoveInScc);
        }
        if (logBuilder != null) {
            logBuilder.append("\nRemovals:\n  Global: ").append(toRemove);
            for (sccIndex = 0; sccIndex < sccs.size(); ++sccIndex) {
                logBuilder.append("\n  ").append(sccIndex).append(": ").append(pairsToRemoveInSccs.get(sccIndex));
            }
            logger.log(Level.FINEST, logBuilder.toString());
        }
        for (sccIndex = 0; sccIndex < sccs.size(); ++sccIndex) {
            Set<S> scc = sccs.get(sccIndex);
            Set pairsToRemoveInScc = (Set)pairsToRemoveInSccs.get(sccIndex);
            if (pairsToRemoveInScc.isEmpty()) continue;
            BitSet indicesToRemoveInScc = new BitSet();
            pairsToRemoveInScc.forEach(pair -> pair.forEachInfSet(indicesToRemoveInScc::set));
            AcceptanceOptimizations.removeIndices(automaton, scc, indicesToRemoveInScc);
        }
        BitSet indicesToRemove = new BitSet();
        toRemove.forEach(pair -> pair.forEachIndex(indicesToRemove::set));
        AcceptanceOptimizations.removeAndRemapIndices(automaton, indicesToRemove);
        automaton.acceptance(acceptance.filter(indicesToRemove::get));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void minimizeSccIrrelevant(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        Object indicesToRemove;
        GeneralizedRabinAcceptance acceptance = (GeneralizedRabinAcceptance)automaton.acceptance();
        List finOnlyPairs = acceptance.pairs().stream().filter(x -> !x.hasInfSet()).collect(Collectors.toUnmodifiableList());
        for (Set scc : SccDecomposition.of(automaton).sccsWithoutTransient()) {
            ImmutableBitSet indicesInScc = AutomatonUtil.getAcceptanceSets(automaton, scc);
            indicesToRemove = new BitSet();
            for (GeneralizedRabinAcceptance.RabinPair pair2 : acceptance.pairs()) {
                boolean finOccurring = indicesInScc.contains(pair2.finSet());
                boolean infOccurring = false;
                boolean impossibleIndexFound = false;
                for (int number = 0; !(number >= pair2.infSetCount() || impossibleIndexFound && infOccurring); ++number) {
                    if (indicesInScc.contains(pair2.infSet(number))) {
                        infOccurring = true;
                        continue;
                    }
                    impossibleIndexFound = true;
                }
                if (!infOccurring && !finOccurring) continue;
                if (impossibleIndexFound) {
                    pair2.forEachIndex(((BitSet)indicesToRemove)::set);
                }
                if (finOccurring) continue;
                ((BitSet)indicesToRemove).set(pair2.finSet());
            }
            BitSet indicesInSccBitSet = indicesInScc.copyInto(new BitSet());
            finOnlyPairs.stream().filter(pair -> !indicesInScc.contains(pair.finSet())).findAny().ifPresent(pair -> {
                indicesInSccBitSet.clear(pair.finSet());
                AcceptanceOptimizations.removeIndices(automaton, scc, indicesInSccBitSet);
            });
            AcceptanceOptimizations.removeIndices(automaton, scc, (BitSet)indicesToRemove);
        }
        BitSet indicesOnEveryEdge = new BitSet();
        indicesOnEveryEdge.set(0, acceptance.acceptanceSets());
        BitSet occurringIndices = new BitSet();
        AutomatonUtil.forEachNonTransientEdge(automaton, (state, edge) -> {
            edge.colours().copyInto(occurringIndices);
            indicesOnEveryEdge.and(edge.colours().copyInto(new BitSet()));
        });
        HashSet<GeneralizedRabinAcceptance.RabinPair> impossiblePairs = new HashSet<GeneralizedRabinAcceptance.RabinPair>();
        for (GeneralizedRabinAcceptance.RabinPair pair3 : acceptance.pairs()) {
            if (indicesOnEveryEdge.get(pair3.finSet())) {
                impossiblePairs.add(pair3);
                continue;
            }
            boolean anyInfOccurring = false;
            boolean impossibleInfFound = false;
            for (int i = 0; !(i >= pair3.infSetCount() || anyInfOccurring && impossibleInfFound); ++i) {
                int infiniteIndex = pair3.infSet(i);
                if (occurringIndices.get(infiniteIndex)) {
                    anyInfOccurring = true;
                    continue;
                }
                impossibleInfFound = true;
                impossiblePairs.add(pair3);
            }
        }
        logger.log(Level.FINER, "Removing impossible pairs {0}", new Object[]{impossiblePairs});
        indicesToRemove = new BitSet();
        impossiblePairs.forEach(arg_0 -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizeSccIrrelevant$26((BitSet)indicesToRemove, arg_0));
        AcceptanceOptimizations.removeAndRemapIndices(automaton, (BitSet)indicesToRemove);
        automaton.updateAcceptance(arg_0 -> GeneralizedRabinAcceptanceOptimizations.lambda$minimizeSccIrrelevant$27((BitSet)indicesToRemove, arg_0));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    public static <S> void mergeBuchiTypePairs(MutableAutomaton<S, GeneralizedRabinAcceptance> automaton) {
        ImmutableBitSet colours = AutomatonUtil.getAcceptanceSets(automaton);
        List buchiTypePairs = ((GeneralizedRabinAcceptance)automaton.acceptance()).pairs().stream().filter(x -> x.infSetCount() == 1 && !colours.contains(x.finSet())).collect(Collectors.toList());
        if (buchiTypePairs.size() < 2) {
            return;
        }
        Iterator pairsIterator = buchiTypePairs.iterator();
        GeneralizedRabinAcceptance.RabinPair representativePair = (GeneralizedRabinAcceptance.RabinPair)pairsIterator.next();
        BitSet indicesToRemoveFin = new BitSet();
        BitSet indicesToRemoveInf = new BitSet();
        pairsIterator.forEachRemaining(x -> {
            indicesToRemoveFin.set(x.finSet());
            indicesToRemoveInf.set(x.infSet());
        });
        automaton.updateEdges((state, edge) -> edge.mapAcceptance(x -> {
            Preconditions.checkState((!indicesToRemoveFin.get(x) ? 1 : 0) != 0);
            return indicesToRemoveInf.get(x) ? representativePair.infSet() : x;
        }));
        BitSet indicesToRemove = new BitSet();
        indicesToRemoveFin.stream().forEach(indicesToRemove::set);
        indicesToRemoveInf.stream().forEach(indicesToRemove::set);
        AcceptanceOptimizations.removeAndRemapIndices(automaton, indicesToRemove);
        automaton.updateAcceptance(x -> x.filter(indicesToRemove::get));
        assert (((GeneralizedRabinAcceptance)automaton.acceptance()).isWellFormedAutomaton(automaton));
    }

    private static /* synthetic */ GeneralizedRabinAcceptance lambda$minimizeSccIrrelevant$27(BitSet indicesToRemove, GeneralizedRabinAcceptance x) {
        return x.filter(indicesToRemove::get);
    }

    private static /* synthetic */ void lambda$minimizeSccIrrelevant$26(BitSet indicesToRemove, GeneralizedRabinAcceptance.RabinPair pair) {
        pair.forEachIndex(indicesToRemove::set);
    }

    private static final class MergeClass {
        final BitSet activeSccIndices;
        final SortedSet<GeneralizedRabinAcceptance.RabinPair> pairs = new TreeSet<GeneralizedRabinAcceptance.RabinPair>();
        @Nonnegative
        final int representativeFin;
        final BitSet representativeInf;

        MergeClass(GeneralizedRabinAcceptance.RabinPair pair, BitSet activeIndices) {
            this.pairs.add(pair);
            this.activeSccIndices = BitSet2.copyOf(activeIndices);
            this.representativeFin = pair.finSet();
            this.representativeInf = new BitSet();
            pair.forEachInfSet(this.representativeInf::set);
        }

        public String toString() {
            return String.format("%s (%s)", this.pairs, this.activeSccIndices);
        }

        boolean tryMerge(MergeClass other) {
            if (this.equals(other)) {
                return false;
            }
            assert (Sets.intersection(this.pairs, other.pairs).isEmpty());
            if (this.activeSccIndices.intersects(other.activeSccIndices)) {
                return false;
            }
            if (this.representativeInf.cardinality() < other.representativeInf.cardinality()) {
                return false;
            }
            assert (other.pairs.stream().allMatch(pair -> pair.infSetCount() <= this.representativeInf.cardinality()));
            this.activeSccIndices.or(other.activeSccIndices);
            this.pairs.addAll(other.pairs);
            return true;
        }
    }
}

