/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import owl.automaton.SuccessorFunction;

final class Tarjan<S> {
    private static final int NO_LINK = Integer.MAX_VALUE;
    private final Deque<S> explorationStack = new ArrayDeque<S>();
    private final Predicate<? super Set<S>> earlyTermination;
    private final Deque<TarjanState<S>> path = new ArrayDeque<TarjanState<S>>();
    private final Set<S> processedNodes = new HashSet<S>();
    private final Map<S, TarjanState<S>> stateMap = new HashMap<S, TarjanState<S>>();
    private final SuccessorFunction<S> successorFunction;
    private int index = 0;
    private boolean earlyTerminationOccurred = false;

    Tarjan(SuccessorFunction<S> successorFunction, Predicate<? super Set<S>> earlyTermination) {
        this.successorFunction = successorFunction;
        this.earlyTermination = earlyTermination;
    }

    private boolean isTransient(Set<? extends S> scc) {
        if (scc.size() > 1) {
            return false;
        }
        Object state = Iterables.getOnlyElement(scc);
        return !this.successorFunction.apply(state).contains(state);
    }

    private TarjanState<S> create(S node) {
        assert (!this.stateMap.containsKey(node) && !this.processedNodes.contains(node)) : String.format("Node %s already processed", node);
        if (this.index == Integer.MAX_VALUE) {
            throw new IllegalStateException("exhausted node ids");
        }
        int nodeIndex = this.index++;
        Iterator successorIterator = this.successorFunction.apply((Object)node).iterator();
        TarjanState<S> state = new TarjanState<S>(node, nodeIndex, successorIterator);
        this.explorationStack.push(node);
        this.stateMap.put(node, state);
        return state;
    }

    boolean run(S initial) {
        Preconditions.checkState((!this.earlyTerminationOccurred ? 1 : 0) != 0, (Object)"An early termination occurred. Internal data-structures are inconsistent.");
        assert (this.path.isEmpty());
        if (this.stateMap.containsKey(initial) || this.processedNodes.contains(initial)) {
            return false;
        }
        TarjanState<S> state = this.create(initial);
        block0: while (true) {
            Object node = state.node;
            int nodeIndex = state.nodeIndex;
            Iterator successorIterator = state.successorIterator;
            while (successorIterator.hasNext()) {
                Object successor = successorIterator.next();
                if (Objects.equals(node, successor)) {
                    if (state.lowLink != Integer.MAX_VALUE) continue;
                    state.lowLink = nodeIndex;
                    continue;
                }
                if (this.processedNodes.contains(successor)) continue;
                TarjanState<S> successorState = this.stateMap.get(successor);
                assert (successorState != state);
                if (successorState == null) {
                    this.path.push(state);
                    state = this.create(successor);
                    continue block0;
                }
                int successorIndex = successorState.nodeIndex;
                assert (successorIndex != nodeIndex);
                int successorLowLink = successorState.getLowLink();
                if (successorLowLink < state.lowLink) {
                    state.lowLink = successorLowLink;
                }
                assert (state.lowLink <= nodeIndex);
            }
            int lowLink = state.lowLink;
            if (lowLink == Integer.MAX_VALUE) {
                assert (Objects.equals(this.explorationStack.peek(), node));
                assert (this.isTransient(Set.of(node)));
                if (this.earlyTermination.test(Set.of(node))) {
                    this.earlyTerminationOccurred = true;
                    return true;
                }
                this.explorationStack.pop();
                this.processedNodes.add(node);
            } else if (lowLink == nodeIndex) {
                Set scc;
                assert (!this.explorationStack.isEmpty());
                S stackNode = this.explorationStack.pop();
                if (stackNode == node) {
                    scc = Set.of(node);
                    assert (!this.isTransient(scc));
                } else {
                    scc = new HashSet();
                    scc.add(stackNode);
                    do {
                        stackNode = this.explorationStack.pop();
                        scc.add(stackNode);
                    } while (stackNode != node);
                }
                this.stateMap.keySet().removeAll(scc);
                this.processedNodes.addAll(scc);
                if (this.earlyTermination.test(scc)) {
                    this.earlyTerminationOccurred = true;
                    return true;
                }
            } else {
                assert (!this.path.isEmpty() && lowLink < nodeIndex);
                TarjanState<S> predecessorState = this.path.getFirst();
                int predecessorLowLink = predecessorState.lowLink;
                if (lowLink < predecessorLowLink) {
                    predecessorState.lowLink = lowLink;
                }
            }
            if (this.path.isEmpty()) break;
            state = this.path.pop();
        }
        assert (this.path.isEmpty());
        return false;
    }

    private static final class TarjanState<S> {
        private final S node;
        private final int nodeIndex;
        private final Iterator<S> successorIterator;
        private int lowLink;

        private TarjanState(S node, int nodeIndex, Iterator<S> successorIterator) {
            this.node = node;
            this.nodeIndex = nodeIndex;
            this.successorIterator = successorIterator;
            this.lowLink = Integer.MAX_VALUE;
        }

        private int getLowLink() {
            return this.lowLink == Integer.MAX_VALUE ? this.nodeIndex : this.lowLink;
        }

        public String toString() {
            return this.nodeIndex + "(" + (Serializable)(this.lowLink == Integer.MAX_VALUE ? "X" : Integer.valueOf(this.lowLink)) + ") " + this.node;
        }
    }
}

