/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.symbolic.AutoValue_SymbolicAutomaton;
import owl.automaton.symbolic.NumberingStateEncoderFactory;
import owl.automaton.symbolic.RangedVariableAllocator;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.collections.ImmutableBitSet;

@AutoValue
public abstract class SymbolicAutomaton<A extends EmersonLeiAcceptance> {
    public abstract List<String> atomicPropositions();

    public abstract BddSet initialStates();

    public abstract BddSet transitionRelation();

    public abstract A acceptance();

    public abstract VariableAllocation variableAllocation();

    public abstract Set<Automaton.Property> properties();

    public abstract int colourOffset();

    public BddSet successors(BddSet statesAndValuation) {
        Preconditions.checkArgument((statesAndValuation.factory() == this.factory() ? 1 : 0) != 0);
        ImmutableBitSet quantifyOver = this.variableAllocation().variables(VariableType.STATE, VariableType.ATOMIC_PROPOSITION);
        ImmutableBitSet states = this.variableAllocation().variables(VariableType.STATE);
        ImmutableBitSet successorStates = this.variableAllocation().variables(VariableType.SUCCESSOR_STATE);
        return this.transitionRelation().intersection(statesAndValuation.project(this.variableAllocation().variables(VariableType.COLOUR))).project(quantifyOver).relabel(variable -> {
            if (states.contains(variable)) {
                return this.variableAllocation().localToGlobal(this.variableAllocation().globalToLocal(variable, VariableType.STATE), VariableType.SUCCESSOR_STATE);
            }
            if (successorStates.contains(variable)) {
                return this.variableAllocation().localToGlobal(this.variableAllocation().globalToLocal(variable, VariableType.SUCCESSOR_STATE), VariableType.STATE);
            }
            return variable;
        });
    }

    public BddSet predecessors(BddSet statesAndValuation) {
        Preconditions.checkArgument((statesAndValuation.factory() == this.factory() ? 1 : 0) != 0);
        ImmutableBitSet quantifyOver = this.variableAllocation().variables(VariableType.SUCCESSOR_STATE, VariableType.ATOMIC_PROPOSITION, VariableType.COLOUR);
        ImmutableBitSet successorStates = this.variableAllocation().variables(VariableType.SUCCESSOR_STATE);
        ImmutableBitSet states = this.variableAllocation().variables(VariableType.STATE);
        return this.transitionRelation().intersection(statesAndValuation.relabel(variable -> {
            if (successorStates.contains(variable)) {
                return this.variableAllocation().localToGlobal(this.variableAllocation().globalToLocal(variable, VariableType.SUCCESSOR_STATE), VariableType.STATE);
            }
            if (states.contains(variable)) {
                return this.variableAllocation().localToGlobal(this.variableAllocation().globalToLocal(variable, VariableType.STATE), VariableType.SUCCESSOR_STATE);
            }
            return variable;
        })).project(quantifyOver);
    }

    @Memoized
    public BddSet reachableStates() {
        BddSet previousStates = this.initialStates().factory().of(false);
        BddSet currentStates = this.initialStates().intersection(this.initialStates().factory().of(new BitSet(), this.variableAllocation().variables(VariableType.COLOUR).copyInto(new BitSet())));
        while (!previousStates.equals(currentStates)) {
            previousStates = currentStates;
            currentStates = currentStates.union(this.successors(currentStates));
        }
        return currentStates;
    }

    public boolean is(Automaton.Property property) {
        return this.properties().contains((Object)property);
    }

    public BddSetFactory factory() {
        return this.transitionRelation().factory();
    }

    static <A extends EmersonLeiAcceptance> SymbolicAutomaton<A> of(List<String> atomicPropositions, BddSet initialStates, BddSet transitionRelation, A acceptance, VariableAllocation variableAllocation, Set<Automaton.Property> properties) {
        Preconditions.checkArgument((boolean)initialStates.factory().equals(transitionRelation.factory()));
        return SymbolicAutomaton.of(List.copyOf(atomicPropositions), initialStates, transitionRelation, acceptance, variableAllocation, Set.copyOf(properties), 0);
    }

    static <A extends EmersonLeiAcceptance> SymbolicAutomaton<A> of(List<String> atomicPropositions, BddSet initialStates, BddSet transitionRelation, A acceptance, VariableAllocation variableAllocation, Set<Automaton.Property> properties, int colourOffset) {
        return new AutoValue_SymbolicAutomaton<A>(List.copyOf(atomicPropositions), initialStates, transitionRelation, acceptance, variableAllocation, Set.copyOf(properties), colourOffset);
    }

    public static <S, A extends EmersonLeiAcceptance> SymbolicAutomaton<A> of(Automaton<S, ? extends A> automaton) {
        return SymbolicAutomaton.of(automaton, FactorySupplier.defaultSupplier().getBddSetFactory(), automaton.atomicPropositions());
    }

    public static <S, A extends EmersonLeiAcceptance> SymbolicAutomaton<A> of(Automaton<S, ? extends A> automaton, BddSetFactory factory, List<String> atomicPropositions) {
        Preconditions.checkArgument((Collections.indexOfSubList(atomicPropositions, automaton.atomicPropositions()) == 0 ? 1 : 0) != 0);
        return SymbolicAutomaton.of(automaton, atomicPropositions, factory, NumberingStateEncoderFactory.INSTANCE, new RangedVariableAllocator(VariableType.ATOMIC_PROPOSITION, VariableType.STATE, VariableType.COLOUR, VariableType.SUCCESSOR_STATE));
    }

    private static <S, A extends EmersonLeiAcceptance> SymbolicAutomaton<A> of(Automaton<S, ? extends A> automaton, List<String> atomicPropositions, BddSetFactory factory, StateEncoderFactory encoderFactory, VariableAllocator allocator) {
        List<String> atomicPropositionsCopy = List.copyOf(atomicPropositions);
        StateEncoder<Object> stateEncoder = encoderFactory.create(automaton);
        VariableAllocation allocation = allocator.allocate(stateEncoder.stateVariables(), atomicPropositionsCopy.size(), ((EmersonLeiAcceptance)automaton.acceptance()).acceptanceSets());
        BddSet initialStates = factory.of(false);
        ArrayDeque<S> workList = new ArrayDeque<S>();
        HashSet<S> exploredStates = new HashSet<S>();
        for (S initialState : automaton.initialStates()) {
            BitSet stateEncoding = stateEncoder.encode(initialState);
            initialStates = initialStates.union(factory.of(allocation.localToGlobal(stateEncoding, VariableType.STATE), allocation.variables(VariableType.STATE).copyInto(new BitSet())));
            workList.add(initialState);
            exploredStates.add(initialState);
        }
        BddSet transitionRelation = factory.of(false);
        while (!workList.isEmpty()) {
            Object state = workList.remove();
            MtBdd<Edge<S>> edgeTree = automaton.edgeTree(state);
            BitSet stateEncoding = stateEncoder.encode(state);
            BddSet stateValuationSet = factory.of(allocation.localToGlobal(stateEncoding, VariableType.STATE), allocation.variables(VariableType.STATE).copyInto(new BitSet()));
            transitionRelation = transitionRelation.union(stateValuationSet.intersection(SymbolicAutomaton.encodeEdgeTree(factory, edgeTree, stateEncoder, allocation)));
            for (Edge<S> edge : edgeTree.flatValues()) {
                if (!exploredStates.add(edge.successor())) continue;
                workList.add(edge.successor());
            }
        }
        Set<Automaton.Property> properties = Arrays.stream(Automaton.Property.values()).filter(automaton::is).collect(Collectors.toUnmodifiableSet());
        return SymbolicAutomaton.of(atomicPropositionsCopy, initialStates, transitionRelation, automaton.acceptance(), allocation, properties);
    }

    private static <S> BddSet encodeEdgeTree(BddSetFactory factory, MtBdd<Edge<S>> edgeTree, StateEncoder<S> encoder, VariableAllocation allocation) {
        if (edgeTree instanceof MtBdd.Leaf) {
            MtBdd.Leaf leaf = (MtBdd.Leaf)edgeTree;
            BddSet edges = factory.of(false);
            for (Edge edge : leaf.value) {
                BitSet successorEncoding = allocation.localToGlobal(encoder.encode(edge.successor()), VariableType.SUCCESSOR_STATE);
                BitSet coloursEncoding = allocation.localToGlobal(edge.colours().copyInto(new BitSet()), VariableType.COLOUR);
                successorEncoding.or(coloursEncoding);
                ImmutableBitSet mask = allocation.variables(VariableType.SUCCESSOR_STATE, VariableType.COLOUR);
                edges = edges.union(factory.of(successorEncoding, mask));
            }
            return edges;
        }
        MtBdd.Node node = (MtBdd.Node)edgeTree;
        BddSet trueEdges = SymbolicAutomaton.encodeEdgeTree(factory, node.trueChild, encoder, allocation);
        BddSet falseEdges = SymbolicAutomaton.encodeEdgeTree(factory, node.falseChild, encoder, allocation);
        BddSet atomicProposition = factory.of(allocation.localToGlobal(node.variable, VariableType.ATOMIC_PROPOSITION));
        return trueEdges.intersection(atomicProposition).union(falseEdges.intersection(atomicProposition.complement()));
    }

    @Memoized
    public Automaton<ImmutableBitSet, A> toAutomaton() {
        final VariableAllocation allocation = this.variableAllocation();
        Set initialStates = Streams.stream(this.initialStates().iterator(allocation.variables(VariableType.STATE))).map(x -> allocation.globalToLocal((BitSet)x, VariableType.STATE)).collect(Collectors.toUnmodifiableSet());
        return new AbstractMemoizingAutomaton.EdgesImplementation<ImmutableBitSet, A>(this.atomicPropositions(), this.factory(), initialStates, (EmersonLeiAcceptance)this.acceptance()){

            @Override
            protected Set<Edge<ImmutableBitSet>> edgesImpl(ImmutableBitSet state, BitSet valuation) {
                BddSet stateSingletonSet = this.factory.of(allocation.localToGlobal(state.copyInto(new BitSet()), VariableType.STATE), allocation.variables(VariableType.STATE).copyInto(new BitSet()));
                BddSet atomicPropositionsSingletonSet = this.factory.of(allocation.localToGlobal(valuation, VariableType.ATOMIC_PROPOSITION), allocation.variables(VariableType.ATOMIC_PROPOSITION).copyInto(new BitSet()));
                BddSet edgesSet = stateSingletonSet.intersection(atomicPropositionsSingletonSet).intersection(SymbolicAutomaton.this.transitionRelation());
                return Streams.stream(edgesSet.iterator(allocation.numberOfVariables())).map(edge -> {
                    assert (state.equals(allocation.globalToLocal((BitSet)edge, VariableType.STATE)));
                    return Edge.of(allocation.globalToLocal((BitSet)edge, VariableType.SUCCESSOR_STATE), allocation.globalToLocal((BitSet)edge, VariableType.COLOUR).copyInto(new BitSet()).get(SymbolicAutomaton.this.colourOffset(), SymbolicAutomaton.this.colourOffset() + ((EmersonLeiAcceptance)this.acceptance()).acceptanceSets()));
                }).collect(Collectors.toUnmodifiableSet());
            }
        };
    }

    static interface AllocationCombiner
    extends VariableAllocation {
        public int localToGlobal(int var1, VariableAllocation var2);

        public int globalToLocal(int var1, VariableAllocation var2);

        default public BitSet localToGlobal(BitSet bitSet, VariableAllocation allocation) {
            BitSet result = new BitSet();
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                result.set(this.localToGlobal(i, allocation));
                i = bitSet.nextSetBit(i + 1);
            }
            return result;
        }

        default public BitSet globalToLocal(BitSet bitSet, VariableAllocation allocation) {
            BitSet result = new BitSet();
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                result.set(this.globalToLocal(i, allocation));
                i = bitSet.nextSetBit(i + 1);
            }
            return result;
        }
    }

    public static interface VariableAllocation {
        public ImmutableBitSet variables(VariableType ... var1);

        default public int numberOfVariables() {
            return this.variables(VariableType.values()).size();
        }

        default public VariableType typeOf(int variable) {
            for (VariableType type : VariableType.values()) {
                if (!this.variables(type).contains(variable)) continue;
                return type;
            }
            throw new IllegalArgumentException(variable + " is not a variable!");
        }

        public List<String> variableNames();

        public int localToGlobal(int var1, VariableType var2);

        public int globalToLocal(int var1, VariableType var2);

        default public BitSet localToGlobal(BitSet bitSet, VariableType type) {
            BitSet result = new BitSet();
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                result.set(this.localToGlobal(i, type));
                i = bitSet.nextSetBit(i + 1);
            }
            return result;
        }

        default public ImmutableBitSet globalToLocal(BitSet bitSet, VariableType type) {
            BitSet result = new BitSet();
            ImmutableBitSet variables = this.variables(type);
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                if (variables.contains(i)) {
                    result.set(this.globalToLocal(i, type));
                }
                i = bitSet.nextSetBit(i + 1);
            }
            return ImmutableBitSet.copyOf(result);
        }
    }

    static enum VariableType {
        STATE,
        COLOUR,
        ATOMIC_PROPOSITION,
        SUCCESSOR_STATE;

    }

    public static interface VariableAllocator {
        public VariableAllocation allocate(int var1, int var2, int var3);
    }

    public static interface StateEncoder<S> {
        public int stateVariables();

        public BitSet encode(S var1);
    }

    public static interface StateEncoderFactory {
        public <S> StateEncoder<S> create(Automaton<? extends S, ?> var1);
    }
}

