/*
 * Decompiled with CFR 0.152.
 */
package owl.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Stream;
import jhoafparser.consumer.HOAConsumerException;
import owl.automaton.Automaton;
import owl.automaton.BooleanOperations;
import owl.automaton.ParityUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.degeneralization.BuchiDegeneralization;
import owl.automaton.acceptance.degeneralization.RabinDegeneralization;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.acceptance.transformer.ZielonkaTreeTransformations;
import owl.automaton.algorithm.simulations.BuchiSimulation;
import owl.automaton.minimization.GfgCoBuchiMinimization;
import owl.command.AbstractOwlSubcommand;
import owl.command.Mixins;
import owl.translations.dra2dpa.IARBuilder;
import owl.translations.nba2ldba.NBA2LDBA;
import owl.translations.nbadet.NbaDet;
import owl.translations.nbadet.NbaDetConf;
import owl.translations.nbadet.NbaLangInclusions;
import picocli.CommandLine;

public class AutomatonConversionCommands {

    @CommandLine.Command(name="nba2dpa", aliases={"nbadet"}, description={"Convert a non-deterministic B\u00fcchi automaton to a deterministic parity automaton.", "Usage Examples: ", "  owl nba2dpa -i input-file -o output-file", "  owl ltl2nba -f 'F (a & G b)' | owl nba2dpa -m MUELLER_SCHUPP", "The construction and the optimisations are described in [LP19b] and [LP19a], respectively. To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."}, showDefaultValues=true)
    public static final class Nba2DpaCommand
    extends AbstractAutomaton2AutomatonCommand<BuchiAcceptance, ParityAcceptance> {
        private static final String DEFAULT_TRUE = "By default this option is enabled.";
        private static final String DEFAULT_FALSE = "By default this option is disabled.";
        @CommandLine.Option(names={"-m", "--merge-mode"}, description={"Which merge method to use in construction (${COMPLETION-CANDIDATES})."}, defaultValue="SAFRA")
        private NbaDetConf.UpdateMode mergeMode = NbaDetConf.UpdateMode.SAFRA;
        @CommandLine.Option(names={"--verbosity"}, description={"Set verbosity level (e.g. INFO, WARNING, FINE, FINER, FINEST)."})
        private String verbosity = Level.WARNING.toString();
        @CommandLine.Option(names={"-l", "--compute-lang-inclusions"}, description={"List of algorithms to use on NBA to obtain language inclusions. Possible values: ${COMPLETION-CANDIDATES}."}, defaultValue="DIRECT_REFINEMENT_SIM")
        private NbaLangInclusions.SimType[] computeSims = null;
        @CommandLine.Option(names={"-e", "--use-sim-external"}, description={"Use results of simulation calculation for preprocessing and optimization. This optimisation is broken and might produce wrong results. By default this option is disabled."}, negatable=true, defaultValue="false", hidden=true)
        private boolean simExt = false;
        @CommandLine.Option(names={"-j", "--use-sim-internal"}, description={"Use results of simulation calculation to prune the deterministic states. By default this option is enabled."}, negatable=true)
        private boolean simInt = true;
        @CommandLine.Option(names={"-t", "--use-powersets"}, description={"Use powerset structure of NBA to guide determinization. By default this option is enabled."}, negatable=true)
        private boolean usePowersets = true;
        @CommandLine.Option(names={"-s", "--use-smart-succ"}, description={"Try to redirect edges to suitable already existing states on-the-fly. By default this option is enabled."}, negatable=true)
        private boolean useSmartSucc = true;
        @CommandLine.Option(names={"-r", "--sep-rej"}, description={"Separate simplified handling for states in rejecting SCCs. By default this option is enabled."}, negatable=true)
        private boolean sepRej = true;
        @CommandLine.Option(names={"-A", "--sep-acc"}, description={"Separate simplified handling for states in accepting SCCs. By default this option is disabled."}, negatable=true)
        private boolean sepAcc = false;
        @CommandLine.Option(names={"-b", "--sep-acc-cycle"}, description={"Cycle breakpoint construction for accepting SCCs. By default this option is disabled."}, negatable=true)
        private boolean sepAccCyc = false;
        @CommandLine.Option(names={"-d", "--sep-det"}, description={"Separate simplified handling for deterministic SCCs. By default this option is enabled."}, negatable=true)
        private boolean sepDet = true;
        @CommandLine.Option(names={"-c", "--sep-sccs"}, description={"Separate handling of all SCCs (that are not already specially handled). By default this option is enabled."}, negatable=true)
        private boolean sepMix = true;

        public Nba2DpaCommand() {
        }

        public Nba2DpaCommand(Nba2DpaCommand that, NbaDetConf.UpdateMode mergeMode) {
            this.mergeMode = mergeMode;
            this.verbosity = that.verbosity();
            this.computeSims = (NbaLangInclusions.SimType[])that.computeSims().toArray(NbaLangInclusions.SimType[]::new);
            this.simExt = that.simExt();
            this.simInt = that.simInt();
            this.usePowersets = that.usePowersets();
            this.useSmartSucc = that.useSmartSucc();
            this.sepRej = that.sepRej();
            this.sepAcc = that.sepAcc();
            this.sepAccCyc = that.sepAccCyc();
            this.sepDet = that.sepDet();
            this.sepMix = that.sepMix();
        }

        @Override
        protected Class<BuchiAcceptance> acceptanceClass() {
            return BuchiAcceptance.class;
        }

        @Override
        protected Function<Automaton<?, ? extends BuchiAcceptance>, Automaton<?, ? extends ParityAcceptance>> conversion() {
            return automaton -> NbaDet.determinize(automaton, this);
        }

        public NbaDetConf.UpdateMode mergeMode() {
            return this.mergeMode;
        }

        public String verbosity() {
            return this.verbosity;
        }

        public List<NbaLangInclusions.SimType> computeSims() {
            return List.of(this.computeSims);
        }

        public boolean simExt() {
            return this.simExt;
        }

        public boolean simInt() {
            return this.simInt;
        }

        public boolean usePowersets() {
            return this.usePowersets;
        }

        public boolean useSmartSucc() {
            return this.useSmartSucc;
        }

        public boolean sepRej() {
            return this.sepRej;
        }

        public boolean sepAcc() {
            return this.sepAcc;
        }

        public boolean sepAccCyc() {
            return this.sepAccCyc;
        }

        public boolean sepDet() {
            return this.sepDet;
        }

        public boolean sepMix() {
            return this.sepMix;
        }

        public String toString() {
            return String.format("Nba2DpaCommand{mergeMode=%s, verbosity='%s', computeSims=%s, simExt=%s, simInt=%s, usePowersets=%s, useSmartSucc=%s, sepRej=%s, sepAcc=%s, sepAccCyc=%s, sepDet=%s, sepMix=%s}", new Object[]{this.mergeMode, this.verbosity, Arrays.toString((Object[])this.computeSims), this.simExt, this.simInt, this.usePowersets, this.useSmartSucc, this.sepRej, this.sepAcc, this.sepAccCyc, this.sepDet, this.sepMix});
        }
    }

    @CommandLine.Command(name="nbasim", description={"Computes the quotient automaton based on a computed set of similar state pairs."})
    public static final class NbaSimCommand
    extends AbstractAutomaton2AutomatonCommand<BuchiAcceptance, BuchiAcceptance> {
        @CommandLine.Option(names={"-s", "--simulation"}, description={"By default ${DEFAULT-VALUE} is selected. The following simulation relations are available: ${COMPLETION-CANDIDATES}.", "DIRECT_SIMULATION: direct simulation relation", "DIRECT_SIMULATION_COLOUR_REFINEMENT: direct simulation relation using color refinement (fast)", "DELAYED_SIMULATION: delayed simulation relation", "FAIR_SIMULATION: fair simulation relation", "BACKWARD_SIMULATION: backwards simulation relation", "LOOKAHEAD_DIRECT_SIMULATION: direct simulation with lookahead"}, defaultValue="DIRECT_SIMULATION")
        private BuchiSimulation.SimulationType simulationType = BuchiSimulation.SimulationType.DIRECT_SIMULATION;
        @CommandLine.Option(names={"-c", "--pebbles"}, description={"Allow duplicator to have the set amount of pebbles"})
        private int pebbleCount = 1;
        @CommandLine.Option(names={"-l", "--lookahead"}, description={"Make this many moves of Spoiler available to Duplicator."})
        private int lookahead = 1;
        @CommandLine.Mixin
        private Mixins.Verifier verifier = null;
        @CommandLine.Option(names={"--verbose"}, description={"Use logging level FINE for more output"})
        private boolean verboseFine = false;

        public BuchiSimulation.SimulationType simulationType() {
            return this.simulationType;
        }

        public int pebbleCount() {
            return this.pebbleCount;
        }

        public int maxLookahead() {
            return this.lookahead;
        }

        public boolean sanity() {
            return this.verifier != null && this.verifier.verify;
        }

        public boolean verboseFine() {
            return this.verboseFine;
        }

        @Override
        protected Class<BuchiAcceptance> acceptanceClass() {
            return BuchiAcceptance.class;
        }

        @Override
        protected Function<Automaton<?, ? extends BuchiAcceptance>, Automaton<?, ? extends BuchiAcceptance>> conversion() {
            return aut -> BuchiSimulation.compute(aut, this);
        }

        @Override
        protected boolean allowSimplifierOnOutput() {
            return false;
        }

        public String toString() {
            return String.format("NbaSimCommand{simulationType=%s, pebbleCount=%d, lookahead=%d, sanity=%s, verboseFine=%s}", new Object[]{this.simulationType, this.pebbleCount, this.lookahead, this.sanity(), this.verboseFine});
        }
    }

    @CommandLine.Command(name="ngba2ldba", description={"Convert a non-deterministic (generalised) B\u00fcchi automaton to a limit-deterministic B\u00fcchi automaton.", "The construction is a generalisation of the construction described in [CY95]. To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ngba2LdbaCommand
    extends AbstractAutomaton2AutomatonCommand<GeneralizedBuchiAcceptance, BuchiAcceptance> {
        Ngba2LdbaCommand() {
        }

        @Override
        protected Class<GeneralizedBuchiAcceptance> acceptanceClass() {
            return GeneralizedBuchiAcceptance.class;
        }

        @Override
        public Function<Automaton<?, ? extends GeneralizedBuchiAcceptance>, Automaton<?, ? extends BuchiAcceptance>> conversion() {
            return automaton -> NBA2LDBA.applyLDBA(automaton).automaton();
        }
    }

    @CommandLine.Command(name="aut-utilities", description={"A collection of various automata related utilities."})
    static final class AutUtilities
    extends AbstractAutomaton2AutomatonCommand<EmersonLeiAcceptance, EmersonLeiAcceptance> {
        @CommandLine.ArgGroup
        private Action action = null;

        AutUtilities() {
        }

        @Override
        protected Class<EmersonLeiAcceptance> acceptanceClass() {
            return EmersonLeiAcceptance.class;
        }

        @Override
        protected Function<Automaton<?, ? extends EmersonLeiAcceptance>, Automaton<?, ? extends EmersonLeiAcceptance>> conversion() {
            return this::convert;
        }

        private Automaton<?, ?> convert(Automaton<?, ?> automaton) {
            if (this.action == null) {
                return automaton;
            }
            Object acceptance = automaton.acceptance();
            if (this.action.degeneralise) {
                if (acceptance instanceof GeneralizedBuchiAcceptance && !(acceptance instanceof BuchiAcceptance)) {
                    return BuchiDegeneralization.degeneralize(OmegaAcceptanceCast.cast(automaton, GeneralizedBuchiAcceptance.class));
                }
                if (acceptance instanceof GeneralizedRabinAcceptance && !(acceptance instanceof RabinAcceptance)) {
                    return RabinDegeneralization.degeneralize(OmegaAcceptanceCast.cast(automaton, GeneralizedRabinAcceptance.class));
                }
            } else {
                if (this.action.deterministicComplement) {
                    return BooleanOperations.deterministicComplement(automaton);
                }
                if (this.action.parity != null) {
                    return ParityUtil.convert(OmegaAcceptanceCast.cast(Views.complete(automaton), ParityAcceptance.class), this.action.parity);
                }
            }
            return automaton;
        }

        private static class Action {
            @CommandLine.Option(names={"--degeneralize"}, description={"Degeneralize a generalized B\u00fcchi or Rabin automata into B\u00fcchi or Rabin automaton, respectively. If the input automaton is deterministic, so is the output."})
            private boolean degeneralise = false;
            @CommandLine.Option(names={"--deterministic-complement"}, description={"Complement a deterministic automaton by negating the acceptance condition."})
            private boolean deterministicComplement = false;
            @CommandLine.Option(names={"--convert-parity-condition"}, description={"Convert the parity condition of an automaton to another type of parity condition. Possible values are: ${COMPLETION-CANDIDATES}."}, hidden=true)
            private ParityAcceptance.Parity parity = null;

            private Action() {
            }
        }
    }

    @CommandLine.Command(name="gfg-minimisation", description={"Compute the minimal, equivalent, transition-based Good-for-Games Co-B\u00fcchi automaton for the given deterministic Co-B\u00fcchi automaton. The polynomial construction is described in [AK19]."})
    static final class GfgMinimisation
    extends AbstractAutomaton2AutomatonCommand<CoBuchiAcceptance, CoBuchiAcceptance> {
        GfgMinimisation() {
        }

        @Override
        protected Class<CoBuchiAcceptance> acceptanceClass() {
            return CoBuchiAcceptance.class;
        }

        @Override
        protected Function<Automaton<?, ? extends CoBuchiAcceptance>, Automaton<?, ? extends CoBuchiAcceptance>> conversion() {
            return GfgCoBuchiMinimization::minimize;
        }
    }

    @CommandLine.Command(name="aut2parity", description={"Convert any type of automaton into a parity automaton. The branching mode of the automaton is preserved, e.g., if the input automaton is deterministic then the output automaton is also deterministic.", "Usage Examples: ", "  owl aut2parity -i input-file -o output-file", "  owl ltl2dela -f 'F (a & G b) & G F c' | owl aut2parity", "The construction is described in [CDMRS22] and is based on [CCF21]. To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Aut2ParityCommand
    extends AbstractAutomaton2AutomatonCommand<EmersonLeiAcceptance, ParityAcceptance> {
        @CommandLine.Option(names={"--iar"}, description={"Use the index-appearance-record construction (IAR) of [KMWW17] if the input automaton is a Rabin automaton. Note that the default construction [CDMRS22] is guaranteed to produce automata smaller or of the same size as the IAR-construction. If the input automaton is not a Rabin automaton, then this command will reject the input with an IllegalArgumentException."}, hidden=true)
        private boolean useIar = false;

        Aut2ParityCommand() {
        }

        @Override
        protected Class<EmersonLeiAcceptance> acceptanceClass() {
            return EmersonLeiAcceptance.class;
        }

        @Override
        protected Function<Automaton<?, ?>, Automaton<?, ? extends ParityAcceptance>> conversion() {
            return this::convert;
        }

        private Automaton<?, ? extends ParityAcceptance> convert(Automaton<?, ?> automaton) {
            if (OmegaAcceptanceCast.isInstanceOf(automaton.acceptance().getClass(), ParityAcceptance.class)) {
                return OmegaAcceptanceCast.cast(automaton, ParityAcceptance.class);
            }
            if (this.useIar) {
                return this.convertIar(automaton);
            }
            return ZielonkaTreeTransformations.transform(automaton);
        }

        private Automaton<?, ? extends ParityAcceptance> convertIar(Automaton<?, ?> automaton) {
            Automaton<Optional<?>, ?> complementAutomaton;
            if (OmegaAcceptanceCast.isInstanceOf(automaton.acceptance().getClass(), RabinAcceptance.class)) {
                Automaton<?, RabinAcceptance> castedAutomaton = OmegaAcceptanceCast.cast(automaton, RabinAcceptance.class);
                return new IARBuilder(castedAutomaton, ParityAcceptance.Parity.MIN_EVEN).build();
            }
            if (automaton.is(Automaton.Property.DETERMINISTIC) && OmegaAcceptanceCast.isInstanceOf((complementAutomaton = BooleanOperations.deterministicComplement(automaton)).acceptance().getClass(), RabinAcceptance.class)) {
                Automaton<Optional<?>, RabinAcceptance> castedAutomaton = OmegaAcceptanceCast.cast(complementAutomaton, RabinAcceptance.class);
                return OmegaAcceptanceCast.cast(BooleanOperations.deterministicComplement(new IARBuilder(castedAutomaton, ParityAcceptance.Parity.MIN_EVEN).build()), ParityAcceptance.class);
            }
            throw new IllegalArgumentException("Only non-deterministic Rabin and deterministic Streett automata can be transformed using the IAR-construction.");
        }
    }

    private static abstract class AbstractAutomaton2AutomatonCommand<A extends EmersonLeiAcceptance, B extends EmersonLeiAcceptance>
    extends AbstractOwlSubcommand {
        @CommandLine.Mixin
        private Mixins.AutomatonReader automatonReader = null;
        @CommandLine.Mixin
        private Mixins.AutomatonWriter automatonWriter = null;
        @CommandLine.Mixin
        private Mixins.AcceptanceSimplifier acceptanceSimplifier = null;
        @CommandLine.Mixin
        private Mixins.Diagnostics diagnostics = null;

        private AbstractAutomaton2AutomatonCommand() {
        }

        @Override
        protected int run() throws IOException, HOAConsumerException {
            Function<Automaton<?, A>, Automaton<?, B>> conversion = this.conversion();
            String subcommand = this.getClass().getAnnotation(CommandLine.Command.class).name();
            int counter = 0;
            try (Stream<Automaton<Integer, A>> source = this.automatonReader.source(this.acceptanceClass());
                 Mixins.AutomatonWriter.Sink sink = this.automatonWriter.sink(subcommand, this.rawArgs());){
                Iterator automatonIterator = source.iterator();
                while (automatonIterator.hasNext()) {
                    Automaton automaton1 = (Automaton)automatonIterator.next();
                    if (!this.acceptanceSimplifier.skipAcceptanceSimplifier) {
                        automaton1 = AcceptanceOptimizations.transform(automaton1);
                    }
                    this.diagnostics.start(String.format("%s (%s)", subcommand, this.rawArgs()), automaton1);
                    Automaton<?, B> automaton2 = conversion.apply(automaton1);
                    this.diagnostics.finish(automaton2);
                    if (this.allowSimplifierOnOutput() && !this.acceptanceSimplifier.skipAcceptanceSimplifier) {
                        automaton2 = AcceptanceOptimizations.transform(automaton2);
                    }
                    sink.accept(automaton2, String.format("Converted Automaton (index: %d)", counter));
                    ++counter;
                }
            }
            return 0;
        }

        protected abstract Class<A> acceptanceClass();

        protected abstract Function<? super Automaton<?, ? extends A>, ? extends Automaton<?, ? extends B>> conversion();

        protected boolean allowSimplifierOnOutput() {
            return true;
        }
    }
}

