/*
 * Decompiled with CFR 0.152.
 */
package owl.command;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.stream.Stream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import owl.command.AbstractOwlSubcommand;
import owl.command.Mixins;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.ltl.rewriter.SimplifierRepository;
import owl.ltl.robust.RobustLtlParser;
import owl.ltl.robust.Robustness;
import owl.translations.mastertheorem.Normalisation;
import picocli.CommandLine;

final class LtlConversionCommands {
    private LtlConversionCommands() {
    }

    @CommandLine.Command(name="rltl2ltl", description={"Convert a robust linear temporal logic (rLTL) formula into a linear temporal logic formula."})
    static final class RLtlReader
    extends AbstractOwlSubcommand {
        @CommandLine.Mixin
        private Mixins.FormulaReader formulaReader = null;
        @CommandLine.Mixin
        private Mixins.FormulaWriter formulaWriter = null;
        @CommandLine.Option(names={"-t", "--truth"}, description={"The truth value that has to be satisfied. Possible values: ${COMPLETION-CANDIDATES}"}, required=true)
        private Robustness robustness = null;

        RLtlReader() {
        }

        @Override
        protected int run() throws IOException {
            try (Stream<String> source = this.formulaReader.stringSource();
                 Mixins.FormulaWriter.Sink sink = this.formulaWriter.sink();){
                Iterator formulaIterator = source.map(line -> {
                    try {
                        return RobustLtlParser.parse(line).toLtl(EnumSet.of(this.robustness));
                    }
                    catch (RecognitionException | ParseCancellationException e) {
                        throw new IllegalArgumentException("Failed to parse LTL formula " + line, e);
                    }
                }).iterator();
                while (formulaIterator.hasNext()) {
                    sink.accept((LabelledFormula)formulaIterator.next());
                }
            }
            return 0;
        }
    }

    @CommandLine.Command(name="ltl2delta2", description={"Rewrite a linear temporal logic (LTL) formula into the \u0394\u2082-normal-form using the construction of [SE20].", "Usage Examples:", "  owl ltl2delta2 -f 'F (a & G (b | F c)) & G F d'", "  owl ltl2delta2 --method=SE20_PI_2_AND_FG_P1_1 -f 'F (a & G (b | F c)) & G F d'", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Delta2Normalisation
    extends AbstractOwlSubcommand {
        @CommandLine.Option(names={"--method"}, description={"Select the normalisation method from [SE20] that should be applied. The default method is ${DEFAULT-VALUE} and the following methods are available: ${COMPLETION-CANDIDATES}.", "SE20_SIGMA_2_AND_GF_SIGMA_1: This method corresponds to [SE20, Theorem 23].", "SE20_PI_2_AND_FG_P1_1: This method corresponds to [SE20, Theorem 27]."}, defaultValue="SE20_SIGMA_2_AND_GF_SIGMA_1")
        private Normalisation.NormalisationMethod method = Normalisation.NormalisationMethod.SE20_SIGMA_2_AND_GF_SIGMA_1;
        @CommandLine.Option(names={"--strict"}, description={"Ensure that the computed formula is not only in \u0394\u2082, i.e., a Boolean combination of formulas from \u03a3\u2082 and \u03a0\u2082, but that depending on the selected normalisation method (see '--method') the formula is a Boolean combination of temporal operators from \u03a3\u2082 and GF(\u03a3\u2081), or \u03a0\u2082 and FG(\u03a0\u2081), respectively."})
        private boolean strict = false;
        @CommandLine.Mixin
        private Mixins.FormulaReader formulaReader = null;
        @CommandLine.Mixin
        private Mixins.FormulaWriter formulaWriter = null;
        @CommandLine.Mixin
        private Mixins.FormulaSimplifier formulaSimplifier = null;
        @CommandLine.Mixin
        private Mixins.Verifier verify = null;

        Delta2Normalisation() {
        }

        @Override
        protected int run() throws IOException {
            try (Stream<LabelledFormula> source = this.formulaReader.source();
                 Mixins.FormulaWriter.Sink sink = this.formulaWriter.sink();){
                Normalisation normalisation = Normalisation.of(this.method, this.strict);
                Iterator formulaIterator = source.iterator();
                while (formulaIterator.hasNext()) {
                    LabelledFormula formula = (LabelledFormula)formulaIterator.next();
                    if (!this.formulaSimplifier.skipSimplifier) {
                        formula = SimplifierRepository.SYNTACTIC_FIXPOINT.apply(formula);
                    }
                    formula = normalisation.apply(formula);
                    if (this.verify != null && this.verify.verify && !SyntacticFragments.DELTA_2.contains(formula)) {
                        throw new AssertionError((Object)"Verification failed.");
                    }
                    if (this.verify != null && this.verify.verify && this.strict) {
                        if (this.method == Normalisation.NormalisationMethod.SE20_SIGMA_2_AND_GF_SIGMA_1) {
                            if (formula.formula().anyMatch(x -> x instanceof Formula.TemporalOperator && !Normalisation.isSigma2OrGfSigma1((Formula.TemporalOperator)x))) {
                                throw new AssertionError((Object)String.format("Verification failed for %s.", formula));
                            }
                        } else if (this.method == Normalisation.NormalisationMethod.SE20_PI_2_AND_FG_PI_1) {
                            if (formula.formula().anyMatch(x -> x instanceof Formula.TemporalOperator && !Normalisation.isPi2OrFgPi1((Formula.TemporalOperator)x))) {
                                throw new AssertionError((Object)String.format("Verification failed for %s.", formula));
                            }
                        } else {
                            throw new IllegalStateException("Unexpected value: " + this.method);
                        }
                    }
                    sink.accept(formula);
                }
            }
            return 0;
        }
    }

    @CommandLine.Command(name="ltl-utilities", description={"A collection of various linear temporal logic related rewriters."})
    static final class LtlUtilities
    extends AbstractOwlSubcommand {
        @CommandLine.Mixin
        private Mixins.FormulaReader formulaReader = null;
        @CommandLine.Mixin
        private Mixins.FormulaWriter formulaWriter = null;
        @CommandLine.Option(names={"--rewriter"}, description={"The rewriter to apply. Possible values are: ${COMPLETION-CANDIDATES}."}, required=true)
        private SimplifierRepository mode = SimplifierRepository.SYNTACTIC_FIXPOINT;

        LtlUtilities() {
        }

        @Override
        protected int run() throws IOException {
            try (Stream<LabelledFormula> source = this.formulaReader.source();
                 Mixins.FormulaWriter.Sink sink = this.formulaWriter.sink();){
                source.map(this.mode::apply).forEachOrdered(formula -> {
                    try {
                        sink.accept((LabelledFormula)formula);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
            }
            return 0;
        }
    }
}

