/*
 * Decompiled with CFR 0.152.
 */
package owl.logic.propositional;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.primitives.ImmutableIntArray;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import owl.logic.propositional.PropositionalFormula;

public class ConjunctiveNormalForm<V> {
    public final ImmutableIntArray clauses;
    public final ImmutableBiMap<V, Integer> variableMapping;
    public final int tsetinVariablesLowerBound;
    public final int tsetinVariablesUpperBound;

    public ConjunctiveNormalForm(PropositionalFormula<V> formula) {
        VariableMappingBuilder<V> temporaryMapping = new VariableMappingBuilder<V>(formula);
        this.tsetinVariablesLowerBound = temporaryMapping.nextFreeVariable;
        this.clauses = ConjunctiveNormalForm.encodeFormula(formula, temporaryMapping);
        this.tsetinVariablesUpperBound = temporaryMapping.nextFreeVariable;
        this.variableMapping = temporaryMapping.variables;
    }

    public boolean evaluate(BitSet assignment) {
        boolean clauseValue = false;
        int s = this.clauses.length();
        for (int i = 0; i < s; ++i) {
            int literal = this.clauses.get(i);
            if (literal == 0) {
                if (!clauseValue) {
                    return false;
                }
                clauseValue = false;
                continue;
            }
            if (clauseValue) continue;
            clauseValue = literal > 0 ? assignment.get(literal - 1) : !assignment.get(-literal - 1);
        }
        return clauseValue;
    }

    private static <V> ImmutableIntArray encodeFormula(PropositionalFormula<V> formula, VariableMappingBuilder<V> variableMapping) {
        PropositionalFormula<V> nnfFormula = formula.nnf();
        ImmutableIntArray.Builder cnfBuilder = ImmutableIntArray.builder((int)(4 * variableMapping.variables.size()));
        if (nnfFormula instanceof PropositionalFormula.Variable) {
            cnfBuilder.add(variableMapping.lookup(nnfFormula));
        } else if (nnfFormula instanceof PropositionalFormula.Negation) {
            PropositionalFormula.Negation negation = (PropositionalFormula.Negation)nnfFormula;
            PropositionalFormula.Variable variable = (PropositionalFormula.Variable)negation.operand;
            cnfBuilder.add(-variableMapping.lookup(variable));
        } else if (nnfFormula instanceof PropositionalFormula.Conjunction || nnfFormula instanceof PropositionalFormula.Disjunction) {
            cnfBuilder.add(variableMapping.lookup(nnfFormula));
            ConjunctiveNormalForm.encodeFormula(nnfFormula, variableMapping, cnfBuilder);
        } else assert (false) : "Unreachable.";
        return cnfBuilder.build();
    }

    private static <V> void encodeFormula(PropositionalFormula<V> formula, VariableMappingBuilder<V> variableMapping, ImmutableIntArray.Builder cnf) {
        if (formula instanceof PropositionalFormula.Variable || formula instanceof PropositionalFormula.Negation) {
            return;
        }
        if (formula instanceof PropositionalFormula.Conjunction) {
            PropositionalFormula.Conjunction conjunction = (PropositionalFormula.Conjunction)formula;
            int conjunctionVariable = variableMapping.lookup(conjunction);
            for (PropositionalFormula conjunct : conjunction.conjuncts) {
                cnf.add(0);
                cnf.add(-conjunctionVariable);
                cnf.add(variableMapping.lookup(conjunct));
            }
            for (PropositionalFormula conjunct : conjunction.conjuncts) {
                ConjunctiveNormalForm.encodeFormula(conjunct, variableMapping, cnf);
            }
        } else {
            PropositionalFormula.Disjunction disjunction = (PropositionalFormula.Disjunction)formula;
            int disjunctionVariable = variableMapping.lookup(disjunction);
            cnf.add(0);
            cnf.add(-disjunctionVariable);
            for (PropositionalFormula disjunct : disjunction.disjuncts) {
                cnf.add(variableMapping.lookup(disjunct));
            }
            for (PropositionalFormula disjunct : disjunction.disjuncts) {
                ConjunctiveNormalForm.encodeFormula(disjunct, variableMapping, cnf);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConjunctiveNormalForm)) {
            return false;
        }
        ConjunctiveNormalForm that = (ConjunctiveNormalForm)o;
        return this.clauses.equals((Object)that.clauses) && this.variableMapping.equals(that.variableMapping);
    }

    public int hashCode() {
        return Objects.hash(this.clauses, this.variableMapping);
    }

    public String toString() {
        return "ConjunctiveNormalForm{clauses=" + this.clauses + ", variableMapping=" + this.variableMapping + "}";
    }

    private static class VariableMappingBuilder<V> {
        private final ImmutableBiMap<V, Integer> variables;
        private final Map<PropositionalFormula.Conjunction<V>, Integer> tseitinConjunctionVariables = new HashMap<PropositionalFormula.Conjunction<V>, Integer>();
        private final Map<PropositionalFormula.Disjunction<V>, Integer> tseitinDisjunctionVariables = new HashMap<PropositionalFormula.Disjunction<V>, Integer>();
        private int nextFreeVariable;

        private VariableMappingBuilder(PropositionalFormula<V> formula) {
            HashMap variables = new HashMap();
            formula.variables().forEach(variable -> variables.put(variable, variables.size() + 1));
            this.variables = ImmutableBiMap.copyOf(variables);
            this.nextFreeVariable = this.variables.size() + 1;
        }

        int lookup(PropositionalFormula<V> formula) {
            PropositionalFormula.Variable variable;
            if (formula instanceof PropositionalFormula.Conjunction) {
                PropositionalFormula.Conjunction conjunction = (PropositionalFormula.Conjunction)formula;
                Integer oldVariable = this.tseitinConjunctionVariables.putIfAbsent(conjunction, this.nextFreeVariable);
                if (oldVariable == null) {
                    int variable2 = this.nextFreeVariable++;
                    return variable2;
                }
                return oldVariable;
            }
            if (formula instanceof PropositionalFormula.Disjunction) {
                PropositionalFormula.Disjunction disjunction = (PropositionalFormula.Disjunction)formula;
                Integer oldVariable = this.tseitinDisjunctionVariables.putIfAbsent(disjunction, this.nextFreeVariable);
                if (oldVariable == null) {
                    int variable3 = this.nextFreeVariable++;
                    return variable3;
                }
                return oldVariable;
            }
            if (formula instanceof PropositionalFormula.Variable) {
                variable = (PropositionalFormula.Variable)formula;
            } else {
                assert (formula instanceof PropositionalFormula.Negation);
                PropositionalFormula.Negation negation = (PropositionalFormula.Negation)formula;
                variable = (PropositionalFormula.Variable)negation.operand;
            }
            int variableId = (Integer)this.variables.get(variable.variable);
            return formula instanceof PropositionalFormula.Negation ? -variableId : variableId;
        }
    }
}

