/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.WOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class MOperator
extends Formula.BinaryTemporalOperator {
    public MOperator(Formula leftOperand, Formula rightOperand) {
        super(MOperator.class, leftOperand, rightOperand);
    }

    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (leftOperand instanceof BooleanConstant || leftOperand instanceof FOperator || leftOperand.equals(rightOperand) || rightOperand.equals(BooleanConstant.FALSE)) {
            return Conjunction.of(leftOperand, rightOperand);
        }
        if (rightOperand == BooleanConstant.TRUE) {
            return FOperator.of(leftOperand);
        }
        if (leftOperand instanceof MOperator && rightOperand.equals(((MOperator)leftOperand).rightOperand())) {
            return leftOperand;
        }
        return new MOperator(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String operatorSymbol() {
        return "M";
    }

    @Override
    public Formula nnf() {
        return MOperator.of(this.leftOperand().nnf(), this.rightOperand().nnf());
    }

    @Override
    public Formula not() {
        return WOperator.of(this.leftOperand().not(), this.rightOperand().not());
    }

    @Override
    public Formula unfold() {
        return Conjunction.of(this.rightOperand().unfold(), Disjunction.of(this.leftOperand().unfold(), (Formula)this));
    }
}

