/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.Converter;

public final class LiteralMapper {
    public static final int UNDEFINED = -1;

    private LiteralMapper() {
    }

    public static ShiftedLabelledFormula shiftLiterals(LabelledFormula labelledFormula) {
        Formula formula = labelledFormula.formula();
        List<String> atomicPropositions = labelledFormula.atomicPropositions();
        BitSet usedAtomicPropositions = formula.atomicPropositions(true);
        int size = usedAtomicPropositions.length();
        ImmutableIntArray.Builder mappingBuilder = ImmutableIntArray.builder((int)size);
        ArrayList<String> mappedAtomicPropositions = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            if (usedAtomicPropositions.get(i)) {
                mappingBuilder.add(mappedAtomicPropositions.size());
                mappedAtomicPropositions.add(atomicPropositions.get(i));
                continue;
            }
            mappingBuilder.add(-1);
        }
        ImmutableIntArray mapping = mappingBuilder.build();
        class LiteralShifter
        extends Converter {
            final /* synthetic */ ImmutableIntArray val$mapping;

            private LiteralShifter(ImmutableIntArray immutableIntArray) {
                this.val$mapping = immutableIntArray;
                super(SyntacticFragment.ALL);
            }

            @Override
            public Formula visit(Literal literal) {
                int mappedAtom = this.val$mapping.get(literal.getAtom());
                assert (mappedAtom != -1);
                assert (mappedAtom <= literal.getAtom());
                return Literal.of(mappedAtom, literal.isNegated());
            }
        }
        LabelledFormula shiftedLabelledFormula = LabelledFormula.of(formula.accept(new LiteralShifter(mapping)), mappedAtomicPropositions);
        return new ShiftedLabelledFormula(shiftedLabelledFormula, mapping);
    }

    public static final class ShiftedLabelledFormula {
        public final LabelledFormula formula;
        public final ImmutableIntArray mapping;

        private ShiftedLabelledFormula(LabelledFormula formula, ImmutableIntArray mapping) {
            this.formula = formula;
            this.mapping = mapping;
        }
    }
}

