/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.function.UnaryOperator;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.PropositionalSimplifier;
import owl.ltl.rewriter.PullUpXVisitor;
import owl.ltl.rewriter.PushDownXVisitor;
import owl.ltl.rewriter.SyntacticFairnessSimplifier;
import owl.ltl.rewriter.SyntacticSimplifier;

public enum SimplifierRepository {
    SYNTACTIC,
    SYNTACTIC_FAIRNESS,
    SYNTACTIC_FIXPOINT,
    PULL_UP_X,
    PUSH_DOWN_X,
    NNF;


    public Formula apply(Formula formula) {
        switch (this) {
            case SYNTACTIC: {
                return ((UnaryOperator)x -> x.substitute(Formula::nnf)).andThen(PropositionalSimplifier.INSTANCE).andThen(SyntacticSimplifier.INSTANCE).apply(formula);
            }
            case SYNTACTIC_FAIRNESS: {
                return (Formula)((UnaryOperator)x -> x.substitute(Formula::nnf)).andThen(SyntacticFairnessSimplifier.NormaliseX.INSTANCE).andThen(SyntacticFairnessSimplifier.INSTANCE).apply(formula);
            }
            case SYNTACTIC_FIXPOINT: {
                Formula before = null;
                Formula after = formula.substitute(Formula::nnf);
                for (int i = 0; i < 100 && !after.equals(before); ++i) {
                    before = after.accept(PropositionalSimplifier.INSTANCE);
                    after = ((Formula)SyntacticSimplifier.INSTANCE.apply(before)).accept(PullUpXVisitor.INSTANCE).toFormula();
                }
                return after;
            }
            case PULL_UP_X: {
                return formula.accept(PullUpXVisitor.INSTANCE).toFormula();
            }
            case PUSH_DOWN_X: {
                return formula.accept(PushDownXVisitor.INSTANCE, 0);
            }
            case NNF: {
                return formula.nnf();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public LabelledFormula apply(LabelledFormula formula) {
        return formula.wrap(this.apply(formula.formula()));
    }
}

