/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dra;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import owl.automaton.Automaton;
import owl.automaton.BooleanOperations;
import owl.automaton.EmptyAutomaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.collections.Pair;
import owl.ltl.BooleanConstant;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.DeterministicConstructionsPortfolio;
import owl.translations.ltl2dra.AbstractNormalformDRAConstruction;

public final class NormalformDRAConstruction<R extends GeneralizedRabinAcceptance>
extends AbstractNormalformDRAConstruction
implements Function<LabelledFormula, Automaton<?, ? extends R>> {
    private final Class<R> acceptanceClass;
    private final DeterministicConstructionsPortfolio<? extends GeneralizedBuchiAcceptance> pi2Portfolio;
    private final DeterministicConstructionsPortfolio<CoBuchiAcceptance> sigma2Portfolio;
    private final DeterministicConstructionsPortfolio<GeneralizedCoBuchiAcceptance> sigma2GeneralizedPortfolio;

    private NormalformDRAConstruction(Class<R> acceptanceClass, boolean useDualConstruction) {
        super(useDualConstruction);
        this.acceptanceClass = acceptanceClass;
        Class buchiAcceptance = acceptanceClass.equals(GeneralizedRabinAcceptance.class) ? GeneralizedBuchiAcceptance.class : BuchiAcceptance.class;
        this.pi2Portfolio = new DeterministicConstructionsPortfolio<GeneralizedBuchiAcceptance>(buchiAcceptance);
        this.sigma2Portfolio = new DeterministicConstructionsPortfolio<CoBuchiAcceptance>(CoBuchiAcceptance.class);
        this.sigma2GeneralizedPortfolio = new DeterministicConstructionsPortfolio<GeneralizedCoBuchiAcceptance>(GeneralizedCoBuchiAcceptance.class);
    }

    public static <R extends GeneralizedRabinAcceptance> NormalformDRAConstruction<R> of(Class<R> acceptanceClass, boolean dualConstruction) {
        return new NormalformDRAConstruction<R>(acceptanceClass, dualConstruction);
    }

    @Override
    public Automaton<?, ? extends R> apply(LabelledFormula formula) {
        LabelledFormula nnfFormula = formula.nnf();
        ArrayList<Automaton<Object, R>> automata = new ArrayList<Automaton<Object, R>>();
        for (AbstractNormalformDRAConstruction.Sigma2Pi2Pair disjunct : this.group(nnfFormula)) {
            Automaton<DeterministicConstructions.BreakpointStateRejectingRoundRobin, BuchiAcceptance> pi2Automaton;
            Automaton sigma2Automaton;
            if (disjunct.pi2().formula().equals(BooleanConstant.TRUE)) {
                sigma2Automaton = this.sigma2GeneralizedPortfolio.apply(disjunct.sigma2()).orElse(null);
                if (sigma2Automaton == null) {
                    sigma2Automaton = DeterministicConstructionsPortfolio.coSafetySafety(disjunct.sigma2());
                }
                automata.add(OmegaAcceptanceCast.cast(sigma2Automaton, this.acceptanceClass));
                continue;
            }
            sigma2Automaton = this.sigma2Portfolio.apply(disjunct.sigma2()).orElse(null);
            if (sigma2Automaton == null) {
                sigma2Automaton = DeterministicConstructionsPortfolio.coSafetySafety(disjunct.sigma2());
            }
            if ((pi2Automaton = (Automaton<DeterministicConstructions.BreakpointStateRejectingRoundRobin, BuchiAcceptance>)this.pi2Portfolio.apply(disjunct.pi2()).orElse(null)) == null) {
                pi2Automaton = DeterministicConstructionsPortfolio.safetyCoSafety(disjunct.pi2());
            }
            automata.add(OmegaAcceptanceCast.cast(BooleanOperations.intersection(sigma2Automaton, pi2Automaton), this.acceptanceClass));
        }
        if (automata.isEmpty()) {
            return OmegaAcceptanceCast.cast(EmptyAutomaton.of(nnfFormula.atomicPropositions(), AllAcceptance.INSTANCE), this.acceptanceClass);
        }
        HashMapAutomaton<Map<Integer, Map>, R> automaton = HashMapAutomaton.copyOf(OmegaAcceptanceCast.cast(BooleanOperations.deterministicUnion(automata), this.acceptanceClass));
        Predicate<Map> isAcceptingSink = state -> state.values().stream().anyMatch(NormalformDRAConstruction::isUniverse);
        Optional<Map> acceptingSink = automaton.states().stream().filter(isAcceptingSink).findAny();
        if (acceptingSink.isPresent()) {
            automaton.updateEdges((state, oldEdge) -> {
                if (isAcceptingSink.test((Map)oldEdge.successor())) {
                    return oldEdge.withSuccessor((Map)acceptingSink.get());
                }
                return oldEdge;
            });
            automaton.trim();
        }
        AcceptanceOptimizations.removeDeadStates(automaton);
        AcceptanceOptimizations.transform(automaton);
        return OmegaAcceptanceCast.cast(automaton, this.acceptanceClass);
    }

    private static boolean isUniverse(Object state) {
        if (state instanceof Pair) {
            Pair pair = (Pair)state;
            return NormalformDRAConstruction.isUniverse(pair.fst()) && NormalformDRAConstruction.isUniverse(pair.snd());
        }
        if (state instanceof EquivalenceClass) {
            return ((EquivalenceClass)state).isTrue();
        }
        if (state instanceof DeterministicConstructions.BreakpointStateAccepting) {
            return ((DeterministicConstructions.BreakpointStateAccepting)state).all().isTrue();
        }
        if (state instanceof DeterministicConstructions.BreakpointStateRejecting) {
            return ((DeterministicConstructions.BreakpointStateRejecting)state).all().isTrue();
        }
        if (state instanceof DeterministicConstructions.BreakpointStateAcceptingRoundRobin) {
            return ((DeterministicConstructions.BreakpointStateAcceptingRoundRobin)state).all().isTrue();
        }
        if (state instanceof DeterministicConstructions.BreakpointStateRejectingRoundRobin) {
            return ((DeterministicConstructions.BreakpointStateRejectingRoundRobin)state).all().isTrue();
        }
        return false;
    }
}

