/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.auto.value.AutoValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import owl.collections.BitSet2;
import owl.collections.Pair;
import owl.translations.nbadet.AutoValue_RankedSlice;
import owl.translations.nbadet.SubsumedStatesMap;

@AutoValue
public abstract class RankedSlice {
    public abstract List<Pair<BitSet, Integer>> slice();

    public static RankedSlice of(List<Pair<BitSet, Integer>> slice) {
        return new AutoValue_RankedSlice(slice);
    }

    public static RankedSlice copy(List<Pair<BitSet, Integer>> slice) {
        ArrayList<Pair<BitSet, Integer>> copy = new ArrayList<Pair<BitSet, Integer>>();
        slice.forEach(p -> copy.add(Pair.of((BitSet)((BitSet)p.fst()).clone(), (Integer)p.snd())));
        return new AutoValue_RankedSlice(copy);
    }

    public static RankedSlice empty() {
        return new AutoValue_RankedSlice(new ArrayList<Pair<BitSet, Integer>>());
    }

    public static RankedSlice singleton(Pair<BitSet, Integer> entry) {
        return new AutoValue_RankedSlice(new ArrayList<Pair<BitSet, Integer>>(Collections.singletonList(entry)));
    }

    public RankedSlice map(Function<Pair<BitSet, Integer>, Pair<BitSet, Integer>> fun) {
        ArrayList<Pair<BitSet, Integer>> sl = new ArrayList<Pair<BitSet, Integer>>();
        for (Pair<BitSet, Integer> e : this.slice()) {
            sl.add(fun.apply(e));
        }
        return RankedSlice.of(sl);
    }

    public RankedSlice leftNormalized() {
        BitSet seen = new BitSet();
        ArrayList<Pair<BitSet, Integer>> sl = new ArrayList<Pair<BitSet, Integer>>();
        for (Pair<BitSet, Integer> p : this.slice()) {
            BitSet bs = (BitSet)p.fst().clone();
            bs.andNot(seen);
            seen.or(bs);
            sl.add(Pair.of(bs, p.snd()));
        }
        return RankedSlice.of(sl);
    }

    public RankedSlice withoutEmptySets() {
        ArrayList<Pair<BitSet, Integer>> sl = new ArrayList<Pair<BitSet, Integer>>();
        for (Pair<BitSet, Integer> p : this.slice()) {
            if (p.fst().isEmpty()) continue;
            sl.add(Pair.of((BitSet)p.fst().clone(), p.snd()));
        }
        return RankedSlice.of(sl);
    }

    public RankedSlice prunedWithSim(SubsumedStatesMap incl) {
        BitSet useless = new BitSet();
        ArrayList<Pair<BitSet, Integer>> sl = new ArrayList<Pair<BitSet, Integer>>();
        for (Pair<BitSet, Integer> p : this.slice()) {
            BitSet upd = BitSet2.without(p.fst(), useless);
            sl.add(Pair.of(upd, p.snd()));
            useless.or(upd);
            upd.stream().forEach(i -> incl.addSubsumed(i, useless));
        }
        return RankedSlice.of(sl);
    }

    RankedSlice fullMerge(Integer domRank) {
        ArrayList<Pair<BitSet, Integer>> sl = new ArrayList<Pair<BitSet, Integer>>();
        if (this.slice().isEmpty()) {
            return RankedSlice.of(sl);
        }
        BitSet curStates = (BitSet)this.slice().get(0).fst().clone();
        int curRank = this.slice().get(0).snd();
        for (int i = 1; i < this.slice().size(); ++i) {
            if (curRank > domRank && this.slice().get(i).snd() >= domRank) {
                curRank = Math.min(curRank, this.slice().get(i).snd());
                curStates.or(this.slice().get(i).fst());
                continue;
            }
            sl.add(Pair.of(curStates, curRank));
            curStates = (BitSet)this.slice().get(i).fst().clone();
            curRank = this.slice().get(i).snd();
        }
        sl.add(Pair.of(curStates, curRank));
        return RankedSlice.of(sl);
    }

    public final String toString() {
        return this.toString(x -> x);
    }

    public final String toString(IntFunction<?> stateMap) {
        return this.slice().stream().map((? super T e) -> BitSet2.asSet((BitSet)e.fst(), stateMap) + ":" + e.snd()).collect(Collectors.joining(", "));
    }

    Pair<ArrayList<Integer>, ArrayList<Integer>> getTreeRelations() {
        ArrayList<Integer> parent = new ArrayList<Integer>(Collections.nCopies(this.slice().size(), 0));
        ArrayList<Integer> lborder = new ArrayList<Integer>(Collections.nCopies(this.slice().size(), 0));
        ArrayDeque<Integer> s = new ArrayDeque<Integer>();
        for (int i = this.slice().size() - 1; i >= 0; --i) {
            while (!s.isEmpty() && this.slice().get(i).snd() < this.slice().get((Integer)s.peek()).snd()) {
                lborder.set((Integer)s.peek(), i);
                s.pop();
            }
            parent.set(i, s.isEmpty() ? -1 : (Integer)s.peek());
            s.push(i);
        }
        while (!s.isEmpty()) {
            lborder.set((Integer)s.peek(), -1);
            s.pop();
        }
        return Pair.of(parent, lborder);
    }
}

