#include <config.h>

#include <assert.h>
#include <locale.h>
#include <mbchar.h>
#include <mbfile.h>
#include <stdio.h>

/* Getc, but smash \r\n as \n.  */
static void
caret_getc (mb_file_t *mbin, mbchar_t *res)
{
  mbf_getc (*res, *mbin);
  if (mb_iseq (*res, '\r'))
    {
      mbchar_t c;
      mbf_getc (c, *mbin);
      if (mb_iseq (c, '\n'))
        mb_copy (res, &c);
      else
        mbf_ungetc (c, *mbin);
    }
}


static void
mb_cat (mb_file_t *mbin, FILE *out)
{
  {
    mbchar_t c;
    caret_getc (mbin, &c);
    while (!mb_iseof (c))
      {
        /* Quote the file (at most the first line in the case of
           multiline locations).  */
        {
          /* Whether we opened the style.  If the line is not as
             expected (maybe the file was changed since the scanner
             ran), we might reach the end before we actually saw the
             opening column.  */
          while (!mb_iseof (c) && !mb_iseq (c, '\n'))
            {
              mb_putc (c, out);
              caret_getc (mbin, &c);
            }
          if (mb_iseq (c, '\n'))
            {
              putc ('\n', out);
              caret_getc (mbin, &c);
            }
        }
      }
  }
}


int
main(int argc, const char *argv[])
{
  setlocale (LC_ALL, "");
  for (int i = 1; i < argc; ++i)
    {
      FILE *file = fopen (argv[i], "r");
      assert (file);
      mb_file_t mbin;
      mbf_init (mbin, file);
      mb_cat (&mbin, stdout);
      fclose (file);
    }
}
