#include "render.hpp"
#include <benchmark/benchmark.h>

void BM_Rendering_base(benchmark::State& st)
{
  int height = 1080;
  int width = height * 16 / 9;
  int stride = width * 3;
  std::vector<std::uint8_t> data(height * width * 3);

  for (auto _ : st)
    render_base(reinterpret_cast<std::byte*>(data.data()), width, height, stride);

  st.SetItemsProcessed(st.iterations() * width * height);
}

BENCHMARK(BM_Rendering_base)
->Unit(benchmark::kMillisecond)
->UseRealTime();

/** Copy for each version **/
void BM_Rendering_simd(benchmark::State& st)
{
  int height = 1080;
  int width = height * 16 / 9;
  int stride = width * 3;
  std::vector<std::uint8_t> data(height * width * 3);

  for (auto _ : st)
    render_simd(reinterpret_cast<std::byte*>(data.data()), width, height, stride);

  st.SetItemsProcessed(st.iterations() * width * height);
}


BENCHMARK(BM_Rendering_simd)
->Unit(benchmark::kMillisecond)
->UseRealTime();

void BM_Rendering_final(benchmark::State& st)
{
  int height = 1080;
  int width = height * 16 / 9;
  int stride = width * 3;
  std::vector<std::uint8_t> data(height * width * 3);

  for (auto _ : st)
    render_final(reinterpret_cast<std::byte*>(data.data()), width, height, stride);

  st.SetItemsProcessed(st.iterations() * width * height);
}


BENCHMARK(BM_Rendering_final)
->Unit(benchmark::kMillisecond)
->UseRealTime();



BENCHMARK_MAIN();
