#pragma once
#include <cstddef>

/// \param buffer The RGB24 image buffer
/// \param width Image width
/// \param height Image height
/// \param stride Number of bytes between two lines
/// \param n_iterations Number of iterations maximal to decide if a point
///                     belongs to the mandelbrot set.
void render_base(std::byte* buffer,
                 int width,
                 int height,
                 std::ptrdiff_t stride,
                 int n_iterations = 100);

void render_mt(std::byte* buffer,
               int width,
               int height,
               std::ptrdiff_t stride,
               int n_iterations = 100);

void render_optim(std::byte* buffer,
                  int width,
                  int height,
                  std::ptrdiff_t stride,
                  int n_iterations = 100);

void render_simd(std::byte* buffer,
                 int width,
                 int height,
                 std::ptrdiff_t stride,
                 int n_iterations = 100);

void render_final(std::byte* buffer,
                  int width,
                  int height,
                  std::ptrdiff_t stride,
                  int n_iterations = 100);




